@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * AzStackHCI fabric model custom properties.
 * @property applianceName Gets or sets the Appliance name.
 * @property azStackHciSiteId Gets or sets the ARM Id of the AzStackHCI site.
 * @property cluster AzStackHCI cluster properties.
 * @property fabricContainerId Gets or sets the fabric container Id.
 * @property fabricResourceId Gets or sets the fabric resource Id.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'AzStackHCI'.
 * @property migrationHubUri Gets or sets the migration hub Uri.
 * @property migrationSolutionId Gets or sets the Migration solution ARM Id.
 */
public data class AzStackHCIFabricModelCustomPropertiesResponse(
    public val applianceName: List<String>,
    public val azStackHciSiteId: String,
    public val cluster: AzStackHCIClusterPropertiesResponse,
    public val fabricContainerId: String,
    public val fabricResourceId: String,
    public val instanceType: String,
    public val migrationHubUri: String,
    public val migrationSolutionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.AzStackHCIFabricModelCustomPropertiesResponse): AzStackHCIFabricModelCustomPropertiesResponse =
            AzStackHCIFabricModelCustomPropertiesResponse(
                applianceName = javaType.applianceName().map({ args0 -> args0 }),
                azStackHciSiteId = javaType.azStackHciSiteId(),
                cluster = javaType.cluster().let({ args0 ->
                    com.pulumi.azurenative.datareplication.kotlin.outputs.AzStackHCIClusterPropertiesResponse.Companion.toKotlin(args0)
                }),
                fabricContainerId = javaType.fabricContainerId(),
                fabricResourceId = javaType.fabricResourceId(),
                instanceType = javaType.instanceType(),
                migrationHubUri = javaType.migrationHubUri(),
                migrationSolutionId = javaType.migrationSolutionId(),
            )
    }
}
