@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Fabric model properties.
 * @property customProperties Fabric model custom properties.
 * @property health Gets or sets the fabric health.
 * @property healthErrors Gets or sets the list of health errors.
 * @property provisioningState Gets or sets the provisioning state of the fabric.
 * @property serviceEndpoint Gets or sets the service endpoint.
 * @property serviceResourceId Gets or sets the service resource Id.
 */
public data class FabricModelPropertiesResponse(
    public val customProperties: Any,
    public val health: String,
    public val healthErrors: List<HealthErrorModelResponse>,
    public val provisioningState: String,
    public val serviceEndpoint: String,
    public val serviceResourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.FabricModelPropertiesResponse): FabricModelPropertiesResponse = FabricModelPropertiesResponse(
            customProperties = javaType.customProperties(),
            health = javaType.health(),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datareplication.kotlin.outputs.HealthErrorModelResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            serviceEndpoint = javaType.serviceEndpoint(),
            serviceResourceId = javaType.serviceResourceId(),
        )
    }
}
