@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Fabric model.
 * @property id Gets or sets the Id of the resource.
 * @property location Gets or sets the location of the fabric.
 * @property name Gets or sets the name of the resource.
 * @property properties Fabric model properties.
 * @property systemData
 * @property tags Gets or sets the resource tags.
 * @property type Gets or sets the type of the resource.
 */
public data class GetFabricResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val properties: FabricModelPropertiesResponse,
    public val systemData: FabricModelResponseSystemData,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.GetFabricResult): GetFabricResult = GetFabricResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.FabricModelPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.FabricModelResponseSystemData.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
