@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Policy model.
 * @property id Gets or sets the Id of the resource.
 * @property name Gets or sets the name of the resource.
 * @property properties Policy model properties.
 * @property systemData
 * @property type Gets or sets the type of the resource.
 */
public data class GetPolicyResult(
    public val id: String,
    public val name: String,
    public val properties: PolicyModelPropertiesResponse,
    public val systemData: PolicyModelResponseSystemData,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.GetPolicyResult): GetPolicyResult = GetPolicyResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.PolicyModelPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.PolicyModelResponseSystemData.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
