@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Protected item model.
 * @property id Gets or sets the Id of the resource.
 * @property name Gets or sets the name of the resource.
 * @property properties Protected item model properties.
 * @property systemData
 * @property type Gets or sets the type of the resource.
 */
public data class GetProtectedItemResult(
    public val id: String,
    public val name: String,
    public val properties: ProtectedItemModelPropertiesResponse,
    public val systemData: ProtectedItemModelResponseSystemData,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.GetProtectedItemResult): GetProtectedItemResult = GetProtectedItemResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.ProtectedItemModelPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.ProtectedItemModelResponseSystemData.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
