@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity model.
 * @property aadAuthority Gets or sets the authority of the SPN with which Dra communicates to service.
 * @property applicationId Gets or sets the client/application Id of the SPN with which Dra communicates to
 * service.
 * @property audience Gets or sets the audience of the SPN with which Dra communicates to service.
 * @property objectId Gets or sets the object Id of the SPN with which Dra communicates to service.
 * @property tenantId Gets or sets the tenant Id of the SPN with which Dra communicates to service.
 */
public data class IdentityModelResponse(
    public val aadAuthority: String,
    public val applicationId: String,
    public val audience: String,
    public val objectId: String,
    public val tenantId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.IdentityModelResponse): IdentityModelResponse = IdentityModelResponse(
            aadAuthority = javaType.aadAuthority(),
            applicationId = javaType.applicationId(),
            audience = javaType.audience(),
            objectId = javaType.objectId(),
            tenantId = javaType.tenantId(),
        )
    }
}
