@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Inner health error model.
 * @property category Gets or sets the error category.
 * @property causes Gets or sets possible causes of the error.
 * @property code Gets or sets the error code.
 * @property creationTime Gets or sets the error creation time.
 * @property healthCategory Gets or sets the health category.
 * @property isCustomerResolvable Gets or sets a value indicating whether the error is customer resolvable.
 * @property message Gets or sets the error message.
 * @property recommendation Gets or sets recommended action to resolve the error.
 * @property severity Gets or sets the error severity.
 * @property source Gets or sets the error source.
 * @property summary Gets or sets the error summary.
 */
public data class InnerHealthErrorModelResponse(
    public val category: String,
    public val causes: String,
    public val code: String,
    public val creationTime: String,
    public val healthCategory: String,
    public val isCustomerResolvable: Boolean,
    public val message: String,
    public val recommendation: String,
    public val severity: String,
    public val source: String,
    public val summary: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.InnerHealthErrorModelResponse): InnerHealthErrorModelResponse = InnerHealthErrorModelResponse(
            category = javaType.category(),
            causes = javaType.causes(),
            code = javaType.code(),
            creationTime = javaType.creationTime(),
            healthCategory = javaType.healthCategory(),
            isCustomerResolvable = javaType.isCustomerResolvable(),
            message = javaType.message(),
            recommendation = javaType.recommendation(),
            severity = javaType.severity(),
            source = javaType.source(),
            summary = javaType.summary(),
        )
    }
}
