@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Protected item model properties.
 * @property allowedJobs Gets or sets the allowed scenarios on the protected item.
 * @property correlationId Gets or sets the protected item correlation Id.
 * @property currentJob
 * @property customProperties Protected item model custom properties.
 * @property draId Gets or sets the DRA Id.
 * @property fabricId Gets or sets the fabric Id.
 * @property fabricObjectId Gets or sets the fabric object Id.
 * @property fabricObjectName Gets or sets the fabric object name.
 * @property healthErrors Gets or sets the list of health errors.
 * @property lastFailedEnableProtectionJob
 * @property lastFailedPlannedFailoverJob
 * @property lastSuccessfulPlannedFailoverTime Gets or sets the Last successful planned failover time.
 * @property lastSuccessfulTestFailoverTime Gets or sets the Last successful test failover time.
 * @property lastSuccessfulUnplannedFailoverTime Gets or sets the Last successful unplanned failover time.
 * @property lastTestFailoverJob
 * @property policyName Gets or sets the policy name.
 * @property protectionState Gets or sets the protection state.
 * @property protectionStateDescription Gets or sets the protection state description.
 * @property provisioningState Gets or sets the provisioning state of the Dra.
 * @property replicationExtensionName Gets or sets the replication extension name.
 * @property replicationHealth Gets or sets protected item replication health.
 * @property resyncRequired Gets or sets a value indicating whether resynchronization is required or not.
 * @property resynchronizationState Gets or sets the resynchronization state.
 * @property sourceFabricProviderId Gets or sets the source fabric provider Id.
 * @property targetDraId Gets or sets the target DRA Id.
 * @property targetFabricId Gets or sets the target fabric Id.
 * @property targetFabricProviderId Gets or sets the target fabric provider Id.
 * @property testFailoverState Gets or sets the test failover state.
 * @property testFailoverStateDescription Gets or sets the Test failover state description.
 */
public data class ProtectedItemModelPropertiesResponse(
    public val allowedJobs: List<String>,
    public val correlationId: String,
    public val currentJob: ProtectedItemModelPropertiesResponseCurrentJob,
    public val customProperties: Either<HyperVToAzStackHCIProtectedItemModelCustomPropertiesResponse, VMwareToAzStackHCIProtectedItemModelCustomPropertiesResponse>,
    public val draId: String,
    public val fabricId: String,
    public val fabricObjectId: String,
    public val fabricObjectName: String,
    public val healthErrors: List<HealthErrorModelResponse>,
    public val lastFailedEnableProtectionJob: ProtectedItemModelPropertiesResponseLastFailedEnableProtectionJob,
    public val lastFailedPlannedFailoverJob: ProtectedItemModelPropertiesResponseLastFailedPlannedFailoverJob,
    public val lastSuccessfulPlannedFailoverTime: String,
    public val lastSuccessfulTestFailoverTime: String,
    public val lastSuccessfulUnplannedFailoverTime: String,
    public val lastTestFailoverJob: ProtectedItemModelPropertiesResponseLastTestFailoverJob,
    public val policyName: String,
    public val protectionState: String,
    public val protectionStateDescription: String,
    public val provisioningState: String,
    public val replicationExtensionName: String,
    public val replicationHealth: String,
    public val resyncRequired: Boolean,
    public val resynchronizationState: String,
    public val sourceFabricProviderId: String,
    public val targetDraId: String,
    public val targetFabricId: String,
    public val targetFabricProviderId: String,
    public val testFailoverState: String,
    public val testFailoverStateDescription: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.ProtectedItemModelPropertiesResponse): ProtectedItemModelPropertiesResponse = ProtectedItemModelPropertiesResponse(
            allowedJobs = javaType.allowedJobs().map({ args0 -> args0 }),
            correlationId = javaType.correlationId(),
            currentJob = javaType.currentJob().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.ProtectedItemModelPropertiesResponseCurrentJob.Companion.toKotlin(args0)
            }),
            customProperties = javaType.customProperties().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datareplication.kotlin.outputs.HyperVToAzStackHCIProtectedItemModelCustomPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datareplication.kotlin.outputs.VMwareToAzStackHCIProtectedItemModelCustomPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            draId = javaType.draId(),
            fabricId = javaType.fabricId(),
            fabricObjectId = javaType.fabricObjectId(),
            fabricObjectName = javaType.fabricObjectName(),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datareplication.kotlin.outputs.HealthErrorModelResponse.Companion.toKotlin(args0)
                })
            }),
            lastFailedEnableProtectionJob = javaType.lastFailedEnableProtectionJob().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.ProtectedItemModelPropertiesResponseLastFailedEnableProtectionJob.Companion.toKotlin(args0)
            }),
            lastFailedPlannedFailoverJob = javaType.lastFailedPlannedFailoverJob().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.ProtectedItemModelPropertiesResponseLastFailedPlannedFailoverJob.Companion.toKotlin(args0)
            }),
            lastSuccessfulPlannedFailoverTime = javaType.lastSuccessfulPlannedFailoverTime(),
            lastSuccessfulTestFailoverTime = javaType.lastSuccessfulTestFailoverTime(),
            lastSuccessfulUnplannedFailoverTime = javaType.lastSuccessfulUnplannedFailoverTime(),
            lastTestFailoverJob = javaType.lastTestFailoverJob().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.ProtectedItemModelPropertiesResponseLastTestFailoverJob.Companion.toKotlin(args0)
            }),
            policyName = javaType.policyName(),
            protectionState = javaType.protectionState(),
            protectionStateDescription = javaType.protectionStateDescription(),
            provisioningState = javaType.provisioningState(),
            replicationExtensionName = javaType.replicationExtensionName(),
            replicationHealth = javaType.replicationHealth(),
            resyncRequired = javaType.resyncRequired(),
            resynchronizationState = javaType.resynchronizationState(),
            sourceFabricProviderId = javaType.sourceFabricProviderId(),
            targetDraId = javaType.targetDraId(),
            targetFabricId = javaType.targetFabricId(),
            targetFabricProviderId = javaType.targetFabricProviderId(),
            testFailoverState = javaType.testFailoverState(),
            testFailoverStateDescription = javaType.testFailoverStateDescription(),
        )
    }
}
