@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Replication extension model properties.
 * @property customProperties Replication extension model custom properties.
 * @property provisioningState Gets or sets the provisioning state of the replication extension.
 */
public data class ReplicationExtensionModelPropertiesResponse(
    public val customProperties: Either<HyperVToAzStackHCIReplicationExtensionModelCustomPropertiesResponse, VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesResponse>,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.ReplicationExtensionModelPropertiesResponse): ReplicationExtensionModelPropertiesResponse = ReplicationExtensionModelPropertiesResponse(
            customProperties = javaType.customProperties().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datareplication.kotlin.outputs.HyperVToAzStackHCIReplicationExtensionModelCustomPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datareplication.kotlin.outputs.VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            provisioningState = javaType.provisioningState(),
        )
    }
}
