@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VMware migrate fabric model custom properties.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'VMwareMigrate'.
 * @property migrationSolutionId Gets or sets the ARM Id of the migration solution.
 * @property vmwareSiteId Gets or sets the ARM Id of the VMware site.
 */
public data class VMwareMigrateFabricModelCustomPropertiesResponse(
    public val instanceType: String,
    public val migrationSolutionId: String,
    public val vmwareSiteId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.VMwareMigrateFabricModelCustomPropertiesResponse): VMwareMigrateFabricModelCustomPropertiesResponse =
            VMwareMigrateFabricModelCustomPropertiesResponse(
                instanceType = javaType.instanceType(),
                migrationSolutionId = javaType.migrationSolutionId(),
                vmwareSiteId = javaType.vmwareSiteId(),
            )
    }
}
