@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * VMware To AzStackHCI Policy model custom properties.
 * @property appConsistentFrequencyInMinutes Gets or sets the app consistent snapshot frequency (in minutes).
 * @property crashConsistentFrequencyInMinutes Gets or sets the crash consistent snapshot frequency (in minutes).
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'VMwareToAzStackHCI'.
 * @property recoveryPointHistoryInMinutes Gets or sets the duration in minutes until which the recovery points need to be
 * stored.
 */
public data class VMwareToAzStackHCIPolicyModelCustomPropertiesResponse(
    public val appConsistentFrequencyInMinutes: Int,
    public val crashConsistentFrequencyInMinutes: Int,
    public val instanceType: String,
    public val recoveryPointHistoryInMinutes: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.VMwareToAzStackHCIPolicyModelCustomPropertiesResponse): VMwareToAzStackHCIPolicyModelCustomPropertiesResponse =
            VMwareToAzStackHCIPolicyModelCustomPropertiesResponse(
                appConsistentFrequencyInMinutes = javaType.appConsistentFrequencyInMinutes(),
                crashConsistentFrequencyInMinutes = javaType.crashConsistentFrequencyInMinutes(),
                instanceType = javaType.instanceType(),
                recoveryPointHistoryInMinutes = javaType.recoveryPointHistoryInMinutes(),
            )
    }
}
