@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * VMwareToAzStackHCI protected disk properties.
 * @property capacityInBytes Gets or sets the disk capacity in bytes.
 * @property diskType Gets or sets the disk type.
 * @property isDynamic Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard
 * disk.
 * @property isOsDisk Gets or sets a value indicating whether the disk is the OS disk.
 * @property migrateDiskName Gets or sets the failover clone disk.
 * @property seedDiskName Gets or sets the seed disk name.
 * @property sourceDiskId Gets or sets the source disk Id.
 * @property sourceDiskName Gets or sets the source disk Name.
 * @property storageContainerId Gets or sets the ARM Id of the storage container.
 * @property storageContainerLocalPath Gets or sets the local path of the storage container.
 * @property testMigrateDiskName Gets or sets the test failover clone disk.
 */
public data class VMwareToAzStackHCIProtectedDiskPropertiesResponse(
    public val capacityInBytes: Double,
    public val diskType: String,
    public val isDynamic: Boolean,
    public val isOsDisk: Boolean,
    public val migrateDiskName: String,
    public val seedDiskName: String,
    public val sourceDiskId: String,
    public val sourceDiskName: String,
    public val storageContainerId: String,
    public val storageContainerLocalPath: String,
    public val testMigrateDiskName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.VMwareToAzStackHCIProtectedDiskPropertiesResponse): VMwareToAzStackHCIProtectedDiskPropertiesResponse =
            VMwareToAzStackHCIProtectedDiskPropertiesResponse(
                capacityInBytes = javaType.capacityInBytes(),
                diskType = javaType.diskType(),
                isDynamic = javaType.isDynamic(),
                isOsDisk = javaType.isOsDisk(),
                migrateDiskName = javaType.migrateDiskName(),
                seedDiskName = javaType.seedDiskName(),
                sourceDiskId = javaType.sourceDiskId(),
                sourceDiskName = javaType.sourceDiskName(),
                storageContainerId = javaType.storageContainerId(),
                storageContainerLocalPath = javaType.storageContainerLocalPath(),
                testMigrateDiskName = javaType.testMigrateDiskName(),
            )
    }
}
