@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * VMwareToAzStackHCI NIC properties.
 * @property isPrimaryNic Gets or sets a value indicating whether this is the primary NIC.
 * @property label Gets or sets the NIC label.
 * @property macAddress Gets or sets the NIC mac address.
 * @property networkName Gets or sets the network name.
 * @property nicId Gets or sets the NIC Id.
 * @property selectionTypeForFailover Gets or sets the selection type of the NIC.
 * @property targetNetworkId Gets or sets the target network Id within AzStackHCI Cluster.
 * @property testNetworkId Gets or sets the target test network Id within AzStackHCI Cluster.
 */
public data class VMwareToAzStackHCIProtectedNicPropertiesResponse(
    public val isPrimaryNic: Boolean? = null,
    public val label: String,
    public val macAddress: String,
    public val networkName: String,
    public val nicId: String,
    public val selectionTypeForFailover: String,
    public val targetNetworkId: String,
    public val testNetworkId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.VMwareToAzStackHCIProtectedNicPropertiesResponse): VMwareToAzStackHCIProtectedNicPropertiesResponse =
            VMwareToAzStackHCIProtectedNicPropertiesResponse(
                isPrimaryNic = javaType.isPrimaryNic().map({ args0 -> args0 }).orElse(null),
                label = javaType.label(),
                macAddress = javaType.macAddress(),
                networkName = javaType.networkName(),
                nicId = javaType.nicId(),
                selectionTypeForFailover = javaType.selectionTypeForFailover(),
                targetNetworkId = javaType.targetNetworkId(),
                testNetworkId = javaType.testNetworkId(),
            )
    }
}
