@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.DatashareFunctions.getADLSGen1FileDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getADLSGen1FolderDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getADLSGen2FileDataSetMappingPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getADLSGen2FileDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getADLSGen2FileSystemDataSetMappingPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getADLSGen2FileSystemDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getADLSGen2FolderDataSetMappingPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getADLSGen2FolderDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getAccountPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getBlobContainerDataSetMappingPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getBlobContainerDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getBlobDataSetMappingPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getBlobDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getBlobFolderDataSetMappingPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getBlobFolderDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getInvitationPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getKustoClusterDataSetMappingPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getKustoClusterDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getKustoDatabaseDataSetMappingPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getKustoDatabaseDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getKustoTableDataSetMappingPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getKustoTableDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getScheduledSynchronizationSettingPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getScheduledTriggerPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getSharePlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getShareSubscriptionPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getSqlDBTableDataSetMappingPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getSqlDBTableDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getSqlDWTableDataSetMappingPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getSqlDWTableDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getSynapseWorkspaceSqlPoolTableDataSetMappingPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.getSynapseWorkspaceSqlPoolTableDataSetPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.listShareSubscriptionSourceShareSynchronizationSettingsPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.listShareSubscriptionSynchronizationDetailsPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.listShareSubscriptionSynchronizationsPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.listShareSynchronizationDetailsPlain
import com.pulumi.azurenative.datashare.DatashareFunctions.listShareSynchronizationsPlain
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen1FileDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen1FileDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen1FolderDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen1FolderDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen2FileDataSetMappingPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen2FileDataSetMappingPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen2FileDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen2FileDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen2FileSystemDataSetMappingPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen2FileSystemDataSetMappingPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen2FileSystemDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen2FileSystemDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen2FolderDataSetMappingPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen2FolderDataSetMappingPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen2FolderDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetADLSGen2FolderDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetBlobContainerDataSetMappingPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetBlobContainerDataSetMappingPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetBlobContainerDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetBlobContainerDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetBlobDataSetMappingPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetBlobDataSetMappingPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetBlobDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetBlobDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetBlobFolderDataSetMappingPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetBlobFolderDataSetMappingPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetBlobFolderDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetBlobFolderDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetInvitationPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetInvitationPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetKustoClusterDataSetMappingPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetKustoClusterDataSetMappingPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetKustoClusterDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetKustoClusterDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetKustoDatabaseDataSetMappingPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetKustoDatabaseDataSetMappingPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetKustoDatabaseDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetKustoDatabaseDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetKustoTableDataSetMappingPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetKustoTableDataSetMappingPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetKustoTableDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetKustoTableDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetScheduledSynchronizationSettingPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetScheduledSynchronizationSettingPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetScheduledTriggerPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetScheduledTriggerPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSharePlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSharePlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetShareSubscriptionPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetShareSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSqlDBTableDataSetMappingPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSqlDBTableDataSetMappingPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSqlDBTableDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSqlDBTableDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSqlDWTableDataSetMappingPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSqlDWTableDataSetMappingPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSqlDWTableDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSqlDWTableDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSynapseWorkspaceSqlPoolTableDataSetMappingPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSynapseWorkspaceSqlPoolTableDataSetMappingPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSynapseWorkspaceSqlPoolTableDataSetPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.GetSynapseWorkspaceSqlPoolTableDataSetPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.ListShareSubscriptionSynchronizationDetailsPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.ListShareSubscriptionSynchronizationDetailsPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.ListShareSubscriptionSynchronizationsPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.ListShareSubscriptionSynchronizationsPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.ListShareSynchronizationDetailsPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.ListShareSynchronizationDetailsPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.inputs.ListShareSynchronizationsPlainArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.ListShareSynchronizationsPlainArgsBuilder
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen1FileDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen1FolderDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen2FileDataSetMappingResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen2FileDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen2FileSystemDataSetMappingResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen2FileSystemDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen2FolderDataSetMappingResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen2FolderDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetBlobContainerDataSetMappingResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetBlobContainerDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetBlobDataSetMappingResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetBlobDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetBlobFolderDataSetMappingResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetBlobFolderDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetInvitationResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetKustoClusterDataSetMappingResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetKustoClusterDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetKustoDatabaseDataSetMappingResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetKustoDatabaseDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetKustoTableDataSetMappingResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetKustoTableDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetScheduledSynchronizationSettingResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetScheduledTriggerResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetShareResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetShareSubscriptionResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetSqlDBTableDataSetMappingResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetSqlDBTableDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetSqlDWTableDataSetMappingResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetSqlDWTableDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetSynapseWorkspaceSqlPoolTableDataSetMappingResult
import com.pulumi.azurenative.datashare.kotlin.outputs.GetSynapseWorkspaceSqlPoolTableDataSetResult
import com.pulumi.azurenative.datashare.kotlin.outputs.ListShareSubscriptionSourceShareSynchronizationSettingsResult
import com.pulumi.azurenative.datashare.kotlin.outputs.ListShareSubscriptionSynchronizationDetailsResult
import com.pulumi.azurenative.datashare.kotlin.outputs.ListShareSubscriptionSynchronizationsResult
import com.pulumi.azurenative.datashare.kotlin.outputs.ListShareSynchronizationDetailsResult
import com.pulumi.azurenative.datashare.kotlin.outputs.ListShareSynchronizationsResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen1FileDataSetResult.Companion.toKotlin as getADLSGen1FileDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen1FolderDataSetResult.Companion.toKotlin as getADLSGen1FolderDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen2FileDataSetMappingResult.Companion.toKotlin as getADLSGen2FileDataSetMappingResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen2FileDataSetResult.Companion.toKotlin as getADLSGen2FileDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen2FileSystemDataSetMappingResult.Companion.toKotlin as getADLSGen2FileSystemDataSetMappingResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen2FileSystemDataSetResult.Companion.toKotlin as getADLSGen2FileSystemDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen2FolderDataSetMappingResult.Companion.toKotlin as getADLSGen2FolderDataSetMappingResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetADLSGen2FolderDataSetResult.Companion.toKotlin as getADLSGen2FolderDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetBlobContainerDataSetMappingResult.Companion.toKotlin as getBlobContainerDataSetMappingResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetBlobContainerDataSetResult.Companion.toKotlin as getBlobContainerDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetBlobDataSetMappingResult.Companion.toKotlin as getBlobDataSetMappingResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetBlobDataSetResult.Companion.toKotlin as getBlobDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetBlobFolderDataSetMappingResult.Companion.toKotlin as getBlobFolderDataSetMappingResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetBlobFolderDataSetResult.Companion.toKotlin as getBlobFolderDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetInvitationResult.Companion.toKotlin as getInvitationResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetKustoClusterDataSetMappingResult.Companion.toKotlin as getKustoClusterDataSetMappingResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetKustoClusterDataSetResult.Companion.toKotlin as getKustoClusterDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetKustoDatabaseDataSetMappingResult.Companion.toKotlin as getKustoDatabaseDataSetMappingResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetKustoDatabaseDataSetResult.Companion.toKotlin as getKustoDatabaseDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetKustoTableDataSetMappingResult.Companion.toKotlin as getKustoTableDataSetMappingResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetKustoTableDataSetResult.Companion.toKotlin as getKustoTableDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetScheduledSynchronizationSettingResult.Companion.toKotlin as getScheduledSynchronizationSettingResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetScheduledTriggerResult.Companion.toKotlin as getScheduledTriggerResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetShareResult.Companion.toKotlin as getShareResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetShareSubscriptionResult.Companion.toKotlin as getShareSubscriptionResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetSqlDBTableDataSetMappingResult.Companion.toKotlin as getSqlDBTableDataSetMappingResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetSqlDBTableDataSetResult.Companion.toKotlin as getSqlDBTableDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetSqlDWTableDataSetMappingResult.Companion.toKotlin as getSqlDWTableDataSetMappingResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetSqlDWTableDataSetResult.Companion.toKotlin as getSqlDWTableDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetSynapseWorkspaceSqlPoolTableDataSetMappingResult.Companion.toKotlin as getSynapseWorkspaceSqlPoolTableDataSetMappingResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.GetSynapseWorkspaceSqlPoolTableDataSetResult.Companion.toKotlin as getSynapseWorkspaceSqlPoolTableDataSetResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.ListShareSubscriptionSourceShareSynchronizationSettingsResult.Companion.toKotlin as listShareSubscriptionSourceShareSynchronizationSettingsResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.ListShareSubscriptionSynchronizationDetailsResult.Companion.toKotlin as listShareSubscriptionSynchronizationDetailsResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.ListShareSubscriptionSynchronizationsResult.Companion.toKotlin as listShareSubscriptionSynchronizationsResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.ListShareSynchronizationDetailsResult.Companion.toKotlin as listShareSynchronizationDetailsResultToKotlin
import com.pulumi.azurenative.datashare.kotlin.outputs.ListShareSynchronizationsResult.Companion.toKotlin as listShareSynchronizationsResultToKotlin

public object DatashareFunctions {
    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return An ADLS Gen 1 file data set.
     */
    public suspend fun getADLSGen1FileDataSet(argument: GetADLSGen1FileDataSetPlainArgs): GetADLSGen1FileDataSetResult =
        getADLSGen1FileDataSetResultToKotlin(getADLSGen1FileDataSetPlain(argument.toJava()).await())

    /**
     * @see [getADLSGen1FileDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return An ADLS Gen 1 file data set.
     */
    public suspend fun getADLSGen1FileDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetADLSGen1FileDataSetResult {
        val argument = GetADLSGen1FileDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getADLSGen1FileDataSetResultToKotlin(getADLSGen1FileDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getADLSGen1FileDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetADLSGen1FileDataSetPlainArgs].
     * @return An ADLS Gen 1 file data set.
     */
    public suspend fun getADLSGen1FileDataSet(argument: suspend GetADLSGen1FileDataSetPlainArgsBuilder.() -> Unit): GetADLSGen1FileDataSetResult {
        val builder = GetADLSGen1FileDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getADLSGen1FileDataSetResultToKotlin(getADLSGen1FileDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return An ADLS Gen 1 folder data set.
     */
    public suspend fun getADLSGen1FolderDataSet(argument: GetADLSGen1FolderDataSetPlainArgs): GetADLSGen1FolderDataSetResult =
        getADLSGen1FolderDataSetResultToKotlin(getADLSGen1FolderDataSetPlain(argument.toJava()).await())

    /**
     * @see [getADLSGen1FolderDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return An ADLS Gen 1 folder data set.
     */
    public suspend fun getADLSGen1FolderDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetADLSGen1FolderDataSetResult {
        val argument = GetADLSGen1FolderDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getADLSGen1FolderDataSetResultToKotlin(getADLSGen1FolderDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getADLSGen1FolderDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetADLSGen1FolderDataSetPlainArgs].
     * @return An ADLS Gen 1 folder data set.
     */
    public suspend fun getADLSGen1FolderDataSet(argument: suspend GetADLSGen1FolderDataSetPlainArgsBuilder.() -> Unit): GetADLSGen1FolderDataSetResult {
        val builder = GetADLSGen1FolderDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getADLSGen1FolderDataSetResultToKotlin(getADLSGen1FolderDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return An ADLS Gen 2 file data set.
     */
    public suspend fun getADLSGen2FileDataSet(argument: GetADLSGen2FileDataSetPlainArgs): GetADLSGen2FileDataSetResult =
        getADLSGen2FileDataSetResultToKotlin(getADLSGen2FileDataSetPlain(argument.toJava()).await())

    /**
     * @see [getADLSGen2FileDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return An ADLS Gen 2 file data set.
     */
    public suspend fun getADLSGen2FileDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetADLSGen2FileDataSetResult {
        val argument = GetADLSGen2FileDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getADLSGen2FileDataSetResultToKotlin(getADLSGen2FileDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getADLSGen2FileDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetADLSGen2FileDataSetPlainArgs].
     * @return An ADLS Gen 2 file data set.
     */
    public suspend fun getADLSGen2FileDataSet(argument: suspend GetADLSGen2FileDataSetPlainArgsBuilder.() -> Unit): GetADLSGen2FileDataSetResult {
        val builder = GetADLSGen2FileDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getADLSGen2FileDataSetResultToKotlin(getADLSGen2FileDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSetMapping in a shareSubscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return An ADLS Gen2 file data set mapping.
     */
    public suspend fun getADLSGen2FileDataSetMapping(argument: GetADLSGen2FileDataSetMappingPlainArgs): GetADLSGen2FileDataSetMappingResult =
        getADLSGen2FileDataSetMappingResultToKotlin(getADLSGen2FileDataSetMappingPlain(argument.toJava()).await())

    /**
     * @see [getADLSGen2FileDataSetMapping].
     * @param accountName The name of the share account.
     * @param dataSetMappingName The name of the dataSetMapping.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @return An ADLS Gen2 file data set mapping.
     */
    public suspend fun getADLSGen2FileDataSetMapping(
        accountName: String,
        dataSetMappingName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
    ): GetADLSGen2FileDataSetMappingResult {
        val argument = GetADLSGen2FileDataSetMappingPlainArgs(
            accountName = accountName,
            dataSetMappingName = dataSetMappingName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
        )
        return getADLSGen2FileDataSetMappingResultToKotlin(getADLSGen2FileDataSetMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getADLSGen2FileDataSetMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetADLSGen2FileDataSetMappingPlainArgs].
     * @return An ADLS Gen2 file data set mapping.
     */
    public suspend fun getADLSGen2FileDataSetMapping(argument: suspend GetADLSGen2FileDataSetMappingPlainArgsBuilder.() -> Unit): GetADLSGen2FileDataSetMappingResult {
        val builder = GetADLSGen2FileDataSetMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getADLSGen2FileDataSetMappingResultToKotlin(getADLSGen2FileDataSetMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return An ADLS Gen 2 file system data set.
     */
    public suspend fun getADLSGen2FileSystemDataSet(argument: GetADLSGen2FileSystemDataSetPlainArgs): GetADLSGen2FileSystemDataSetResult =
        getADLSGen2FileSystemDataSetResultToKotlin(getADLSGen2FileSystemDataSetPlain(argument.toJava()).await())

    /**
     * @see [getADLSGen2FileSystemDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return An ADLS Gen 2 file system data set.
     */
    public suspend fun getADLSGen2FileSystemDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetADLSGen2FileSystemDataSetResult {
        val argument = GetADLSGen2FileSystemDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getADLSGen2FileSystemDataSetResultToKotlin(getADLSGen2FileSystemDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getADLSGen2FileSystemDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetADLSGen2FileSystemDataSetPlainArgs].
     * @return An ADLS Gen 2 file system data set.
     */
    public suspend fun getADLSGen2FileSystemDataSet(argument: suspend GetADLSGen2FileSystemDataSetPlainArgsBuilder.() -> Unit): GetADLSGen2FileSystemDataSetResult {
        val builder = GetADLSGen2FileSystemDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getADLSGen2FileSystemDataSetResultToKotlin(getADLSGen2FileSystemDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSetMapping in a shareSubscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return An ADLS Gen2 file system data set mapping.
     */
    public suspend fun getADLSGen2FileSystemDataSetMapping(argument: GetADLSGen2FileSystemDataSetMappingPlainArgs): GetADLSGen2FileSystemDataSetMappingResult =
        getADLSGen2FileSystemDataSetMappingResultToKotlin(getADLSGen2FileSystemDataSetMappingPlain(argument.toJava()).await())

    /**
     * @see [getADLSGen2FileSystemDataSetMapping].
     * @param accountName The name of the share account.
     * @param dataSetMappingName The name of the dataSetMapping.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @return An ADLS Gen2 file system data set mapping.
     */
    public suspend fun getADLSGen2FileSystemDataSetMapping(
        accountName: String,
        dataSetMappingName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
    ): GetADLSGen2FileSystemDataSetMappingResult {
        val argument = GetADLSGen2FileSystemDataSetMappingPlainArgs(
            accountName = accountName,
            dataSetMappingName = dataSetMappingName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
        )
        return getADLSGen2FileSystemDataSetMappingResultToKotlin(getADLSGen2FileSystemDataSetMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getADLSGen2FileSystemDataSetMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetADLSGen2FileSystemDataSetMappingPlainArgs].
     * @return An ADLS Gen2 file system data set mapping.
     */
    public suspend fun getADLSGen2FileSystemDataSetMapping(argument: suspend GetADLSGen2FileSystemDataSetMappingPlainArgsBuilder.() -> Unit): GetADLSGen2FileSystemDataSetMappingResult {
        val builder = GetADLSGen2FileSystemDataSetMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getADLSGen2FileSystemDataSetMappingResultToKotlin(getADLSGen2FileSystemDataSetMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return An ADLS Gen 2 folder data set.
     */
    public suspend fun getADLSGen2FolderDataSet(argument: GetADLSGen2FolderDataSetPlainArgs): GetADLSGen2FolderDataSetResult =
        getADLSGen2FolderDataSetResultToKotlin(getADLSGen2FolderDataSetPlain(argument.toJava()).await())

    /**
     * @see [getADLSGen2FolderDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return An ADLS Gen 2 folder data set.
     */
    public suspend fun getADLSGen2FolderDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetADLSGen2FolderDataSetResult {
        val argument = GetADLSGen2FolderDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getADLSGen2FolderDataSetResultToKotlin(getADLSGen2FolderDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getADLSGen2FolderDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetADLSGen2FolderDataSetPlainArgs].
     * @return An ADLS Gen 2 folder data set.
     */
    public suspend fun getADLSGen2FolderDataSet(argument: suspend GetADLSGen2FolderDataSetPlainArgsBuilder.() -> Unit): GetADLSGen2FolderDataSetResult {
        val builder = GetADLSGen2FolderDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getADLSGen2FolderDataSetResultToKotlin(getADLSGen2FolderDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSetMapping in a shareSubscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return An ADLS Gen2 folder data set mapping.
     */
    public suspend fun getADLSGen2FolderDataSetMapping(argument: GetADLSGen2FolderDataSetMappingPlainArgs): GetADLSGen2FolderDataSetMappingResult =
        getADLSGen2FolderDataSetMappingResultToKotlin(getADLSGen2FolderDataSetMappingPlain(argument.toJava()).await())

    /**
     * @see [getADLSGen2FolderDataSetMapping].
     * @param accountName The name of the share account.
     * @param dataSetMappingName The name of the dataSetMapping.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @return An ADLS Gen2 folder data set mapping.
     */
    public suspend fun getADLSGen2FolderDataSetMapping(
        accountName: String,
        dataSetMappingName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
    ): GetADLSGen2FolderDataSetMappingResult {
        val argument = GetADLSGen2FolderDataSetMappingPlainArgs(
            accountName = accountName,
            dataSetMappingName = dataSetMappingName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
        )
        return getADLSGen2FolderDataSetMappingResultToKotlin(getADLSGen2FolderDataSetMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getADLSGen2FolderDataSetMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetADLSGen2FolderDataSetMappingPlainArgs].
     * @return An ADLS Gen2 folder data set mapping.
     */
    public suspend fun getADLSGen2FolderDataSetMapping(argument: suspend GetADLSGen2FolderDataSetMappingPlainArgsBuilder.() -> Unit): GetADLSGen2FolderDataSetMappingResult {
        val builder = GetADLSGen2FolderDataSetMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getADLSGen2FolderDataSetMappingResultToKotlin(getADLSGen2FolderDataSetMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an account
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return An account data transfer object.
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName The name of the share account.
     * @param resourceGroupName The resource group name.
     * @return An account data transfer object.
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return An account data transfer object.
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit): GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return An Azure storage blob container data set.
     */
    public suspend fun getBlobContainerDataSet(argument: GetBlobContainerDataSetPlainArgs): GetBlobContainerDataSetResult =
        getBlobContainerDataSetResultToKotlin(getBlobContainerDataSetPlain(argument.toJava()).await())

    /**
     * @see [getBlobContainerDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return An Azure storage blob container data set.
     */
    public suspend fun getBlobContainerDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetBlobContainerDataSetResult {
        val argument = GetBlobContainerDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getBlobContainerDataSetResultToKotlin(getBlobContainerDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getBlobContainerDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetBlobContainerDataSetPlainArgs].
     * @return An Azure storage blob container data set.
     */
    public suspend fun getBlobContainerDataSet(argument: suspend GetBlobContainerDataSetPlainArgsBuilder.() -> Unit): GetBlobContainerDataSetResult {
        val builder = GetBlobContainerDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBlobContainerDataSetResultToKotlin(getBlobContainerDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSetMapping in a shareSubscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A Blob container data set mapping.
     */
    public suspend fun getBlobContainerDataSetMapping(argument: GetBlobContainerDataSetMappingPlainArgs): GetBlobContainerDataSetMappingResult =
        getBlobContainerDataSetMappingResultToKotlin(getBlobContainerDataSetMappingPlain(argument.toJava()).await())

    /**
     * @see [getBlobContainerDataSetMapping].
     * @param accountName The name of the share account.
     * @param dataSetMappingName The name of the dataSetMapping.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @return A Blob container data set mapping.
     */
    public suspend fun getBlobContainerDataSetMapping(
        accountName: String,
        dataSetMappingName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
    ): GetBlobContainerDataSetMappingResult {
        val argument = GetBlobContainerDataSetMappingPlainArgs(
            accountName = accountName,
            dataSetMappingName = dataSetMappingName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
        )
        return getBlobContainerDataSetMappingResultToKotlin(getBlobContainerDataSetMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getBlobContainerDataSetMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetBlobContainerDataSetMappingPlainArgs].
     * @return A Blob container data set mapping.
     */
    public suspend fun getBlobContainerDataSetMapping(argument: suspend GetBlobContainerDataSetMappingPlainArgsBuilder.() -> Unit): GetBlobContainerDataSetMappingResult {
        val builder = GetBlobContainerDataSetMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBlobContainerDataSetMappingResultToKotlin(getBlobContainerDataSetMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return An Azure storage blob data set.
     */
    public suspend fun getBlobDataSet(argument: GetBlobDataSetPlainArgs): GetBlobDataSetResult =
        getBlobDataSetResultToKotlin(getBlobDataSetPlain(argument.toJava()).await())

    /**
     * @see [getBlobDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return An Azure storage blob data set.
     */
    public suspend fun getBlobDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetBlobDataSetResult {
        val argument = GetBlobDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getBlobDataSetResultToKotlin(getBlobDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getBlobDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetBlobDataSetPlainArgs].
     * @return An Azure storage blob data set.
     */
    public suspend fun getBlobDataSet(argument: suspend GetBlobDataSetPlainArgsBuilder.() -> Unit): GetBlobDataSetResult {
        val builder = GetBlobDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBlobDataSetResultToKotlin(getBlobDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSetMapping in a shareSubscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A Blob data set mapping.
     */
    public suspend fun getBlobDataSetMapping(argument: GetBlobDataSetMappingPlainArgs): GetBlobDataSetMappingResult =
        getBlobDataSetMappingResultToKotlin(getBlobDataSetMappingPlain(argument.toJava()).await())

    /**
     * @see [getBlobDataSetMapping].
     * @param accountName The name of the share account.
     * @param dataSetMappingName The name of the dataSetMapping.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @return A Blob data set mapping.
     */
    public suspend fun getBlobDataSetMapping(
        accountName: String,
        dataSetMappingName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
    ): GetBlobDataSetMappingResult {
        val argument = GetBlobDataSetMappingPlainArgs(
            accountName = accountName,
            dataSetMappingName = dataSetMappingName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
        )
        return getBlobDataSetMappingResultToKotlin(getBlobDataSetMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getBlobDataSetMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetBlobDataSetMappingPlainArgs].
     * @return A Blob data set mapping.
     */
    public suspend fun getBlobDataSetMapping(argument: suspend GetBlobDataSetMappingPlainArgsBuilder.() -> Unit): GetBlobDataSetMappingResult {
        val builder = GetBlobDataSetMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBlobDataSetMappingResultToKotlin(getBlobDataSetMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return An Azure storage blob folder data set.
     */
    public suspend fun getBlobFolderDataSet(argument: GetBlobFolderDataSetPlainArgs): GetBlobFolderDataSetResult =
        getBlobFolderDataSetResultToKotlin(getBlobFolderDataSetPlain(argument.toJava()).await())

    /**
     * @see [getBlobFolderDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return An Azure storage blob folder data set.
     */
    public suspend fun getBlobFolderDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetBlobFolderDataSetResult {
        val argument = GetBlobFolderDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getBlobFolderDataSetResultToKotlin(getBlobFolderDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getBlobFolderDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetBlobFolderDataSetPlainArgs].
     * @return An Azure storage blob folder data set.
     */
    public suspend fun getBlobFolderDataSet(argument: suspend GetBlobFolderDataSetPlainArgsBuilder.() -> Unit): GetBlobFolderDataSetResult {
        val builder = GetBlobFolderDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBlobFolderDataSetResultToKotlin(getBlobFolderDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSetMapping in a shareSubscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A Blob folder data set mapping.
     */
    public suspend fun getBlobFolderDataSetMapping(argument: GetBlobFolderDataSetMappingPlainArgs): GetBlobFolderDataSetMappingResult =
        getBlobFolderDataSetMappingResultToKotlin(getBlobFolderDataSetMappingPlain(argument.toJava()).await())

    /**
     * @see [getBlobFolderDataSetMapping].
     * @param accountName The name of the share account.
     * @param dataSetMappingName The name of the dataSetMapping.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @return A Blob folder data set mapping.
     */
    public suspend fun getBlobFolderDataSetMapping(
        accountName: String,
        dataSetMappingName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
    ): GetBlobFolderDataSetMappingResult {
        val argument = GetBlobFolderDataSetMappingPlainArgs(
            accountName = accountName,
            dataSetMappingName = dataSetMappingName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
        )
        return getBlobFolderDataSetMappingResultToKotlin(getBlobFolderDataSetMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getBlobFolderDataSetMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetBlobFolderDataSetMappingPlainArgs].
     * @return A Blob folder data set mapping.
     */
    public suspend fun getBlobFolderDataSetMapping(argument: suspend GetBlobFolderDataSetMappingPlainArgsBuilder.() -> Unit): GetBlobFolderDataSetMappingResult {
        val builder = GetBlobFolderDataSetMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBlobFolderDataSetMappingResultToKotlin(getBlobFolderDataSetMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an invitation in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A Invitation data transfer object.
     */
    public suspend fun getInvitation(argument: GetInvitationPlainArgs): GetInvitationResult =
        getInvitationResultToKotlin(getInvitationPlain(argument.toJava()).await())

    /**
     * @see [getInvitation].
     * @param accountName The name of the share account.
     * @param invitationName The name of the invitation.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return A Invitation data transfer object.
     */
    public suspend fun getInvitation(
        accountName: String,
        invitationName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetInvitationResult {
        val argument = GetInvitationPlainArgs(
            accountName = accountName,
            invitationName = invitationName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getInvitationResultToKotlin(getInvitationPlain(argument.toJava()).await())
    }

    /**
     * @see [getInvitation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetInvitationPlainArgs].
     * @return A Invitation data transfer object.
     */
    public suspend fun getInvitation(argument: suspend GetInvitationPlainArgsBuilder.() -> Unit): GetInvitationResult {
        val builder = GetInvitationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInvitationResultToKotlin(getInvitationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A kusto cluster data set.
     */
    public suspend fun getKustoClusterDataSet(argument: GetKustoClusterDataSetPlainArgs): GetKustoClusterDataSetResult =
        getKustoClusterDataSetResultToKotlin(getKustoClusterDataSetPlain(argument.toJava()).await())

    /**
     * @see [getKustoClusterDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return A kusto cluster data set.
     */
    public suspend fun getKustoClusterDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetKustoClusterDataSetResult {
        val argument = GetKustoClusterDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getKustoClusterDataSetResultToKotlin(getKustoClusterDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getKustoClusterDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetKustoClusterDataSetPlainArgs].
     * @return A kusto cluster data set.
     */
    public suspend fun getKustoClusterDataSet(argument: suspend GetKustoClusterDataSetPlainArgsBuilder.() -> Unit): GetKustoClusterDataSetResult {
        val builder = GetKustoClusterDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKustoClusterDataSetResultToKotlin(getKustoClusterDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSetMapping in a shareSubscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A Kusto cluster data set mapping
     */
    public suspend fun getKustoClusterDataSetMapping(argument: GetKustoClusterDataSetMappingPlainArgs): GetKustoClusterDataSetMappingResult =
        getKustoClusterDataSetMappingResultToKotlin(getKustoClusterDataSetMappingPlain(argument.toJava()).await())

    /**
     * @see [getKustoClusterDataSetMapping].
     * @param accountName The name of the share account.
     * @param dataSetMappingName The name of the dataSetMapping.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @return A Kusto cluster data set mapping
     */
    public suspend fun getKustoClusterDataSetMapping(
        accountName: String,
        dataSetMappingName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
    ): GetKustoClusterDataSetMappingResult {
        val argument = GetKustoClusterDataSetMappingPlainArgs(
            accountName = accountName,
            dataSetMappingName = dataSetMappingName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
        )
        return getKustoClusterDataSetMappingResultToKotlin(getKustoClusterDataSetMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getKustoClusterDataSetMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetKustoClusterDataSetMappingPlainArgs].
     * @return A Kusto cluster data set mapping
     */
    public suspend fun getKustoClusterDataSetMapping(argument: suspend GetKustoClusterDataSetMappingPlainArgsBuilder.() -> Unit): GetKustoClusterDataSetMappingResult {
        val builder = GetKustoClusterDataSetMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKustoClusterDataSetMappingResultToKotlin(getKustoClusterDataSetMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A kusto database data set.
     */
    public suspend fun getKustoDatabaseDataSet(argument: GetKustoDatabaseDataSetPlainArgs): GetKustoDatabaseDataSetResult =
        getKustoDatabaseDataSetResultToKotlin(getKustoDatabaseDataSetPlain(argument.toJava()).await())

    /**
     * @see [getKustoDatabaseDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return A kusto database data set.
     */
    public suspend fun getKustoDatabaseDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetKustoDatabaseDataSetResult {
        val argument = GetKustoDatabaseDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getKustoDatabaseDataSetResultToKotlin(getKustoDatabaseDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getKustoDatabaseDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetKustoDatabaseDataSetPlainArgs].
     * @return A kusto database data set.
     */
    public suspend fun getKustoDatabaseDataSet(argument: suspend GetKustoDatabaseDataSetPlainArgsBuilder.() -> Unit): GetKustoDatabaseDataSetResult {
        val builder = GetKustoDatabaseDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKustoDatabaseDataSetResultToKotlin(getKustoDatabaseDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSetMapping in a shareSubscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A Kusto database data set mapping
     */
    public suspend fun getKustoDatabaseDataSetMapping(argument: GetKustoDatabaseDataSetMappingPlainArgs): GetKustoDatabaseDataSetMappingResult =
        getKustoDatabaseDataSetMappingResultToKotlin(getKustoDatabaseDataSetMappingPlain(argument.toJava()).await())

    /**
     * @see [getKustoDatabaseDataSetMapping].
     * @param accountName The name of the share account.
     * @param dataSetMappingName The name of the dataSetMapping.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @return A Kusto database data set mapping
     */
    public suspend fun getKustoDatabaseDataSetMapping(
        accountName: String,
        dataSetMappingName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
    ): GetKustoDatabaseDataSetMappingResult {
        val argument = GetKustoDatabaseDataSetMappingPlainArgs(
            accountName = accountName,
            dataSetMappingName = dataSetMappingName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
        )
        return getKustoDatabaseDataSetMappingResultToKotlin(getKustoDatabaseDataSetMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getKustoDatabaseDataSetMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetKustoDatabaseDataSetMappingPlainArgs].
     * @return A Kusto database data set mapping
     */
    public suspend fun getKustoDatabaseDataSetMapping(argument: suspend GetKustoDatabaseDataSetMappingPlainArgsBuilder.() -> Unit): GetKustoDatabaseDataSetMappingResult {
        val builder = GetKustoDatabaseDataSetMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKustoDatabaseDataSetMappingResultToKotlin(getKustoDatabaseDataSetMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A kusto table data set.
     */
    public suspend fun getKustoTableDataSet(argument: GetKustoTableDataSetPlainArgs): GetKustoTableDataSetResult =
        getKustoTableDataSetResultToKotlin(getKustoTableDataSetPlain(argument.toJava()).await())

    /**
     * @see [getKustoTableDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return A kusto table data set.
     */
    public suspend fun getKustoTableDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetKustoTableDataSetResult {
        val argument = GetKustoTableDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getKustoTableDataSetResultToKotlin(getKustoTableDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getKustoTableDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetKustoTableDataSetPlainArgs].
     * @return A kusto table data set.
     */
    public suspend fun getKustoTableDataSet(argument: suspend GetKustoTableDataSetPlainArgsBuilder.() -> Unit): GetKustoTableDataSetResult {
        val builder = GetKustoTableDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKustoTableDataSetResultToKotlin(getKustoTableDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSetMapping in a shareSubscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A Kusto database data set mapping
     */
    public suspend fun getKustoTableDataSetMapping(argument: GetKustoTableDataSetMappingPlainArgs): GetKustoTableDataSetMappingResult =
        getKustoTableDataSetMappingResultToKotlin(getKustoTableDataSetMappingPlain(argument.toJava()).await())

    /**
     * @see [getKustoTableDataSetMapping].
     * @param accountName The name of the share account.
     * @param dataSetMappingName The name of the dataSetMapping.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @return A Kusto database data set mapping
     */
    public suspend fun getKustoTableDataSetMapping(
        accountName: String,
        dataSetMappingName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
    ): GetKustoTableDataSetMappingResult {
        val argument = GetKustoTableDataSetMappingPlainArgs(
            accountName = accountName,
            dataSetMappingName = dataSetMappingName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
        )
        return getKustoTableDataSetMappingResultToKotlin(getKustoTableDataSetMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getKustoTableDataSetMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetKustoTableDataSetMappingPlainArgs].
     * @return A Kusto database data set mapping
     */
    public suspend fun getKustoTableDataSetMapping(argument: suspend GetKustoTableDataSetMappingPlainArgsBuilder.() -> Unit): GetKustoTableDataSetMappingResult {
        val builder = GetKustoTableDataSetMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKustoTableDataSetMappingResultToKotlin(getKustoTableDataSetMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a synchronizationSetting in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A type of synchronization setting based on schedule
     */
    public suspend fun getScheduledSynchronizationSetting(argument: GetScheduledSynchronizationSettingPlainArgs): GetScheduledSynchronizationSettingResult =
        getScheduledSynchronizationSettingResultToKotlin(getScheduledSynchronizationSettingPlain(argument.toJava()).await())

    /**
     * @see [getScheduledSynchronizationSetting].
     * @param accountName The name of the share account.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @param synchronizationSettingName The name of the synchronizationSetting.
     * @return A type of synchronization setting based on schedule
     */
    public suspend fun getScheduledSynchronizationSetting(
        accountName: String,
        resourceGroupName: String,
        shareName: String,
        synchronizationSettingName: String,
    ): GetScheduledSynchronizationSettingResult {
        val argument = GetScheduledSynchronizationSettingPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
            synchronizationSettingName = synchronizationSettingName,
        )
        return getScheduledSynchronizationSettingResultToKotlin(getScheduledSynchronizationSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getScheduledSynchronizationSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetScheduledSynchronizationSettingPlainArgs].
     * @return A type of synchronization setting based on schedule
     */
    public suspend fun getScheduledSynchronizationSetting(argument: suspend GetScheduledSynchronizationSettingPlainArgsBuilder.() -> Unit): GetScheduledSynchronizationSettingResult {
        val builder = GetScheduledSynchronizationSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScheduledSynchronizationSettingResultToKotlin(getScheduledSynchronizationSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Trigger in a shareSubscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A type of trigger based on schedule
     */
    public suspend fun getScheduledTrigger(argument: GetScheduledTriggerPlainArgs): GetScheduledTriggerResult =
        getScheduledTriggerResultToKotlin(getScheduledTriggerPlain(argument.toJava()).await())

    /**
     * @see [getScheduledTrigger].
     * @param accountName The name of the share account.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @param triggerName The name of the trigger.
     * @return A type of trigger based on schedule
     */
    public suspend fun getScheduledTrigger(
        accountName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
        triggerName: String,
    ): GetScheduledTriggerResult {
        val argument = GetScheduledTriggerPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
            triggerName = triggerName,
        )
        return getScheduledTriggerResultToKotlin(getScheduledTriggerPlain(argument.toJava()).await())
    }

    /**
     * @see [getScheduledTrigger].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetScheduledTriggerPlainArgs].
     * @return A type of trigger based on schedule
     */
    public suspend fun getScheduledTrigger(argument: suspend GetScheduledTriggerPlainArgsBuilder.() -> Unit): GetScheduledTriggerResult {
        val builder = GetScheduledTriggerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScheduledTriggerResultToKotlin(getScheduledTriggerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A share data transfer object.
     */
    public suspend fun getShare(argument: GetSharePlainArgs): GetShareResult =
        getShareResultToKotlin(getSharePlain(argument.toJava()).await())

    /**
     * @see [getShare].
     * @param accountName The name of the share account.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share to retrieve.
     * @return A share data transfer object.
     */
    public suspend fun getShare(
        accountName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetShareResult {
        val argument = GetSharePlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getShareResultToKotlin(getSharePlain(argument.toJava()).await())
    }

    /**
     * @see [getShare].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetSharePlainArgs].
     * @return A share data transfer object.
     */
    public suspend fun getShare(argument: suspend GetSharePlainArgsBuilder.() -> Unit): GetShareResult {
        val builder = GetSharePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getShareResultToKotlin(getSharePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a shareSubscription in an account
     * Azure REST API version: 2021-08-01.
     * Other available API versions: 2018-11-01-preview.
     * @param argument null
     * @return A share subscription data transfer object.
     */
    public suspend fun getShareSubscription(argument: GetShareSubscriptionPlainArgs): GetShareSubscriptionResult =
        getShareSubscriptionResultToKotlin(getShareSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getShareSubscription].
     * @param accountName The name of the share account.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @return A share subscription data transfer object.
     */
    public suspend fun getShareSubscription(
        accountName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
    ): GetShareSubscriptionResult {
        val argument = GetShareSubscriptionPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
        )
        return getShareSubscriptionResultToKotlin(getShareSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getShareSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetShareSubscriptionPlainArgs].
     * @return A share subscription data transfer object.
     */
    public suspend fun getShareSubscription(argument: suspend GetShareSubscriptionPlainArgsBuilder.() -> Unit): GetShareSubscriptionResult {
        val builder = GetShareSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getShareSubscriptionResultToKotlin(getShareSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A SQL DB table data set.
     */
    public suspend fun getSqlDBTableDataSet(argument: GetSqlDBTableDataSetPlainArgs): GetSqlDBTableDataSetResult =
        getSqlDBTableDataSetResultToKotlin(getSqlDBTableDataSetPlain(argument.toJava()).await())

    /**
     * @see [getSqlDBTableDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return A SQL DB table data set.
     */
    public suspend fun getSqlDBTableDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetSqlDBTableDataSetResult {
        val argument = GetSqlDBTableDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getSqlDBTableDataSetResultToKotlin(getSqlDBTableDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlDBTableDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetSqlDBTableDataSetPlainArgs].
     * @return A SQL DB table data set.
     */
    public suspend fun getSqlDBTableDataSet(argument: suspend GetSqlDBTableDataSetPlainArgsBuilder.() -> Unit): GetSqlDBTableDataSetResult {
        val builder = GetSqlDBTableDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlDBTableDataSetResultToKotlin(getSqlDBTableDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSetMapping in a shareSubscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A SQL DB Table data set mapping.
     */
    public suspend fun getSqlDBTableDataSetMapping(argument: GetSqlDBTableDataSetMappingPlainArgs): GetSqlDBTableDataSetMappingResult =
        getSqlDBTableDataSetMappingResultToKotlin(getSqlDBTableDataSetMappingPlain(argument.toJava()).await())

    /**
     * @see [getSqlDBTableDataSetMapping].
     * @param accountName The name of the share account.
     * @param dataSetMappingName The name of the dataSetMapping.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @return A SQL DB Table data set mapping.
     */
    public suspend fun getSqlDBTableDataSetMapping(
        accountName: String,
        dataSetMappingName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
    ): GetSqlDBTableDataSetMappingResult {
        val argument = GetSqlDBTableDataSetMappingPlainArgs(
            accountName = accountName,
            dataSetMappingName = dataSetMappingName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
        )
        return getSqlDBTableDataSetMappingResultToKotlin(getSqlDBTableDataSetMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlDBTableDataSetMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetSqlDBTableDataSetMappingPlainArgs].
     * @return A SQL DB Table data set mapping.
     */
    public suspend fun getSqlDBTableDataSetMapping(argument: suspend GetSqlDBTableDataSetMappingPlainArgsBuilder.() -> Unit): GetSqlDBTableDataSetMappingResult {
        val builder = GetSqlDBTableDataSetMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlDBTableDataSetMappingResultToKotlin(getSqlDBTableDataSetMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A SQL DW table data set.
     */
    public suspend fun getSqlDWTableDataSet(argument: GetSqlDWTableDataSetPlainArgs): GetSqlDWTableDataSetResult =
        getSqlDWTableDataSetResultToKotlin(getSqlDWTableDataSetPlain(argument.toJava()).await())

    /**
     * @see [getSqlDWTableDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return A SQL DW table data set.
     */
    public suspend fun getSqlDWTableDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetSqlDWTableDataSetResult {
        val argument = GetSqlDWTableDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getSqlDWTableDataSetResultToKotlin(getSqlDWTableDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlDWTableDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetSqlDWTableDataSetPlainArgs].
     * @return A SQL DW table data set.
     */
    public suspend fun getSqlDWTableDataSet(argument: suspend GetSqlDWTableDataSetPlainArgsBuilder.() -> Unit): GetSqlDWTableDataSetResult {
        val builder = GetSqlDWTableDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlDWTableDataSetResultToKotlin(getSqlDWTableDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSetMapping in a shareSubscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A SQL DW Table data set mapping.
     */
    public suspend fun getSqlDWTableDataSetMapping(argument: GetSqlDWTableDataSetMappingPlainArgs): GetSqlDWTableDataSetMappingResult =
        getSqlDWTableDataSetMappingResultToKotlin(getSqlDWTableDataSetMappingPlain(argument.toJava()).await())

    /**
     * @see [getSqlDWTableDataSetMapping].
     * @param accountName The name of the share account.
     * @param dataSetMappingName The name of the dataSetMapping.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @return A SQL DW Table data set mapping.
     */
    public suspend fun getSqlDWTableDataSetMapping(
        accountName: String,
        dataSetMappingName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
    ): GetSqlDWTableDataSetMappingResult {
        val argument = GetSqlDWTableDataSetMappingPlainArgs(
            accountName = accountName,
            dataSetMappingName = dataSetMappingName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
        )
        return getSqlDWTableDataSetMappingResultToKotlin(getSqlDWTableDataSetMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlDWTableDataSetMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetSqlDWTableDataSetMappingPlainArgs].
     * @return A SQL DW Table data set mapping.
     */
    public suspend fun getSqlDWTableDataSetMapping(argument: suspend GetSqlDWTableDataSetMappingPlainArgsBuilder.() -> Unit): GetSqlDWTableDataSetMappingResult {
        val builder = GetSqlDWTableDataSetMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlDWTableDataSetMappingResultToKotlin(getSqlDWTableDataSetMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSet in a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A Synapse Workspace Sql Pool Table data set.
     */
    public suspend fun getSynapseWorkspaceSqlPoolTableDataSet(argument: GetSynapseWorkspaceSqlPoolTableDataSetPlainArgs): GetSynapseWorkspaceSqlPoolTableDataSetResult =
        getSynapseWorkspaceSqlPoolTableDataSetResultToKotlin(getSynapseWorkspaceSqlPoolTableDataSetPlain(argument.toJava()).await())

    /**
     * @see [getSynapseWorkspaceSqlPoolTableDataSet].
     * @param accountName The name of the share account.
     * @param dataSetName The name of the dataSet.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @return A Synapse Workspace Sql Pool Table data set.
     */
    public suspend fun getSynapseWorkspaceSqlPoolTableDataSet(
        accountName: String,
        dataSetName: String,
        resourceGroupName: String,
        shareName: String,
    ): GetSynapseWorkspaceSqlPoolTableDataSetResult {
        val argument = GetSynapseWorkspaceSqlPoolTableDataSetPlainArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getSynapseWorkspaceSqlPoolTableDataSetResultToKotlin(getSynapseWorkspaceSqlPoolTableDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getSynapseWorkspaceSqlPoolTableDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetSynapseWorkspaceSqlPoolTableDataSetPlainArgs].
     * @return A Synapse Workspace Sql Pool Table data set.
     */
    public suspend fun getSynapseWorkspaceSqlPoolTableDataSet(argument: suspend GetSynapseWorkspaceSqlPoolTableDataSetPlainArgsBuilder.() -> Unit): GetSynapseWorkspaceSqlPoolTableDataSetResult {
        val builder = GetSynapseWorkspaceSqlPoolTableDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSynapseWorkspaceSqlPoolTableDataSetResultToKotlin(getSynapseWorkspaceSqlPoolTableDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataSetMapping in a shareSubscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A Synapse Workspace Sql Pool Table data set mapping
     */
    public suspend fun getSynapseWorkspaceSqlPoolTableDataSetMapping(argument: GetSynapseWorkspaceSqlPoolTableDataSetMappingPlainArgs): GetSynapseWorkspaceSqlPoolTableDataSetMappingResult =
        getSynapseWorkspaceSqlPoolTableDataSetMappingResultToKotlin(getSynapseWorkspaceSqlPoolTableDataSetMappingPlain(argument.toJava()).await())

    /**
     * @see [getSynapseWorkspaceSqlPoolTableDataSetMapping].
     * @param accountName The name of the share account.
     * @param dataSetMappingName The name of the dataSetMapping.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @return A Synapse Workspace Sql Pool Table data set mapping
     */
    public suspend fun getSynapseWorkspaceSqlPoolTableDataSetMapping(
        accountName: String,
        dataSetMappingName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
    ): GetSynapseWorkspaceSqlPoolTableDataSetMappingResult {
        val argument = GetSynapseWorkspaceSqlPoolTableDataSetMappingPlainArgs(
            accountName = accountName,
            dataSetMappingName = dataSetMappingName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
        )
        return getSynapseWorkspaceSqlPoolTableDataSetMappingResultToKotlin(getSynapseWorkspaceSqlPoolTableDataSetMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getSynapseWorkspaceSqlPoolTableDataSetMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;GetSynapseWorkspaceSqlPoolTableDataSetMappingPlainArgs].
     * @return A Synapse Workspace Sql Pool Table data set mapping
     */
    public suspend fun getSynapseWorkspaceSqlPoolTableDataSetMapping(argument: suspend GetSynapseWorkspaceSqlPoolTableDataSetMappingPlainArgsBuilder.() -> Unit): GetSynapseWorkspaceSqlPoolTableDataSetMappingResult {
        val builder = GetSynapseWorkspaceSqlPoolTableDataSetMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSynapseWorkspaceSqlPoolTableDataSetMappingResultToKotlin(getSynapseWorkspaceSqlPoolTableDataSetMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get synchronization settings set on a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return List response for get source share Synchronization settings
     */
    public suspend fun listShareSubscriptionSourceShareSynchronizationSettings(argument: ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgs): ListShareSubscriptionSourceShareSynchronizationSettingsResult =
        listShareSubscriptionSourceShareSynchronizationSettingsResultToKotlin(listShareSubscriptionSourceShareSynchronizationSettingsPlain(argument.toJava()).await())

    /**
     * @see [listShareSubscriptionSourceShareSynchronizationSettings].
     * @param accountName The name of the share account.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the shareSubscription.
     * @param skipToken Continuation token
     * @return List response for get source share Synchronization settings
     */
    public suspend fun listShareSubscriptionSourceShareSynchronizationSettings(
        accountName: String,
        resourceGroupName: String,
        shareSubscriptionName: String,
        skipToken: String? = null,
    ): ListShareSubscriptionSourceShareSynchronizationSettingsResult {
        val argument = ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
            skipToken = skipToken,
        )
        return listShareSubscriptionSourceShareSynchronizationSettingsResultToKotlin(listShareSubscriptionSourceShareSynchronizationSettingsPlain(argument.toJava()).await())
    }

    /**
     * @see [listShareSubscriptionSourceShareSynchronizationSettings].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgs].
     * @return List response for get source share Synchronization settings
     */
    public suspend fun listShareSubscriptionSourceShareSynchronizationSettings(argument: suspend ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgsBuilder.() -> Unit): ListShareSubscriptionSourceShareSynchronizationSettingsResult {
        val builder = ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listShareSubscriptionSourceShareSynchronizationSettingsResultToKotlin(listShareSubscriptionSourceShareSynchronizationSettingsPlain(builtArgument.toJava()).await())
    }

    /**
     * List synchronization details
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return details of synchronization
     */
    public suspend fun listShareSubscriptionSynchronizationDetails(argument: ListShareSubscriptionSynchronizationDetailsPlainArgs): ListShareSubscriptionSynchronizationDetailsResult =
        listShareSubscriptionSynchronizationDetailsResultToKotlin(listShareSubscriptionSynchronizationDetailsPlain(argument.toJava()).await())

    /**
     * @see [listShareSubscriptionSynchronizationDetails].
     * @param accountName The name of the share account.
     * @param filter Filters the results using OData syntax.
     * @param orderby Sorts the results using OData syntax.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the share subscription.
     * @param skipToken Continuation token
     * @param synchronizationId Synchronization id
     * @return details of synchronization
     */
    public suspend fun listShareSubscriptionSynchronizationDetails(
        accountName: String,
        filter: String? = null,
        orderby: String? = null,
        resourceGroupName: String,
        shareSubscriptionName: String,
        skipToken: String? = null,
        synchronizationId: String,
    ): ListShareSubscriptionSynchronizationDetailsResult {
        val argument = ListShareSubscriptionSynchronizationDetailsPlainArgs(
            accountName = accountName,
            filter = filter,
            orderby = orderby,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
            skipToken = skipToken,
            synchronizationId = synchronizationId,
        )
        return listShareSubscriptionSynchronizationDetailsResultToKotlin(listShareSubscriptionSynchronizationDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [listShareSubscriptionSynchronizationDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;ListShareSubscriptionSynchronizationDetailsPlainArgs].
     * @return details of synchronization
     */
    public suspend fun listShareSubscriptionSynchronizationDetails(argument: suspend ListShareSubscriptionSynchronizationDetailsPlainArgsBuilder.() -> Unit): ListShareSubscriptionSynchronizationDetailsResult {
        val builder = ListShareSubscriptionSynchronizationDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listShareSubscriptionSynchronizationDetailsResultToKotlin(listShareSubscriptionSynchronizationDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * List synchronizations of a share subscription
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return A consumer side list of share subscription synchronizations
     */
    public suspend fun listShareSubscriptionSynchronizations(argument: ListShareSubscriptionSynchronizationsPlainArgs): ListShareSubscriptionSynchronizationsResult =
        listShareSubscriptionSynchronizationsResultToKotlin(listShareSubscriptionSynchronizationsPlain(argument.toJava()).await())

    /**
     * @see [listShareSubscriptionSynchronizations].
     * @param accountName The name of the share account.
     * @param filter Filters the results using OData syntax.
     * @param orderby Sorts the results using OData syntax.
     * @param resourceGroupName The resource group name.
     * @param shareSubscriptionName The name of the share subscription.
     * @param skipToken Continuation token
     * @return A consumer side list of share subscription synchronizations
     */
    public suspend fun listShareSubscriptionSynchronizations(
        accountName: String,
        filter: String? = null,
        orderby: String? = null,
        resourceGroupName: String,
        shareSubscriptionName: String,
        skipToken: String? = null,
    ): ListShareSubscriptionSynchronizationsResult {
        val argument = ListShareSubscriptionSynchronizationsPlainArgs(
            accountName = accountName,
            filter = filter,
            orderby = orderby,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
            skipToken = skipToken,
        )
        return listShareSubscriptionSynchronizationsResultToKotlin(listShareSubscriptionSynchronizationsPlain(argument.toJava()).await())
    }

    /**
     * @see [listShareSubscriptionSynchronizations].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;ListShareSubscriptionSynchronizationsPlainArgs].
     * @return A consumer side list of share subscription synchronizations
     */
    public suspend fun listShareSubscriptionSynchronizations(argument: suspend ListShareSubscriptionSynchronizationsPlainArgsBuilder.() -> Unit): ListShareSubscriptionSynchronizationsResult {
        val builder = ListShareSubscriptionSynchronizationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listShareSubscriptionSynchronizationsResultToKotlin(listShareSubscriptionSynchronizationsPlain(builtArgument.toJava()).await())
    }

    /**
     * List synchronization details
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return details of synchronization
     */
    public suspend fun listShareSynchronizationDetails(argument: ListShareSynchronizationDetailsPlainArgs): ListShareSynchronizationDetailsResult =
        listShareSynchronizationDetailsResultToKotlin(listShareSynchronizationDetailsPlain(argument.toJava()).await())

    /**
     * @see [listShareSynchronizationDetails].
     * @param accountName The name of the share account.
     * @param consumerEmail Email of the user who created the synchronization
     * @param consumerName Name of the user who created the synchronization
     * @param consumerTenantName Tenant name of the consumer who created the synchronization
     * @param durationMs synchronization duration
     * @param endTime End time of synchronization
     * @param filter Filters the results using OData syntax.
     * @param message message of synchronization
     * @param orderby Sorts the results using OData syntax.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @param skipToken Continuation token
     * @param startTime start time of synchronization
     * @param status Raw Status
     * @param synchronizationId Synchronization id
     * @return details of synchronization
     */
    public suspend fun listShareSynchronizationDetails(
        accountName: String,
        consumerEmail: String? = null,
        consumerName: String? = null,
        consumerTenantName: String? = null,
        durationMs: Int? = null,
        endTime: String? = null,
        filter: String? = null,
        message: String? = null,
        orderby: String? = null,
        resourceGroupName: String,
        shareName: String,
        skipToken: String? = null,
        startTime: String? = null,
        status: String? = null,
        synchronizationId: String? = null,
    ): ListShareSynchronizationDetailsResult {
        val argument = ListShareSynchronizationDetailsPlainArgs(
            accountName = accountName,
            consumerEmail = consumerEmail,
            consumerName = consumerName,
            consumerTenantName = consumerTenantName,
            durationMs = durationMs,
            endTime = endTime,
            filter = filter,
            message = message,
            orderby = orderby,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
            skipToken = skipToken,
            startTime = startTime,
            status = status,
            synchronizationId = synchronizationId,
        )
        return listShareSynchronizationDetailsResultToKotlin(listShareSynchronizationDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [listShareSynchronizationDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;ListShareSynchronizationDetailsPlainArgs].
     * @return details of synchronization
     */
    public suspend fun listShareSynchronizationDetails(argument: suspend ListShareSynchronizationDetailsPlainArgsBuilder.() -> Unit): ListShareSynchronizationDetailsResult {
        val builder = ListShareSynchronizationDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listShareSynchronizationDetailsResultToKotlin(listShareSynchronizationDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * List synchronizations of a share
     * Azure REST API version: 2021-08-01.
     * @param argument null
     * @return List response for get ShareSynchronization.
     */
    public suspend fun listShareSynchronizations(argument: ListShareSynchronizationsPlainArgs): ListShareSynchronizationsResult =
        listShareSynchronizationsResultToKotlin(listShareSynchronizationsPlain(argument.toJava()).await())

    /**
     * @see [listShareSynchronizations].
     * @param accountName The name of the share account.
     * @param filter Filters the results using OData syntax.
     * @param orderby Sorts the results using OData syntax.
     * @param resourceGroupName The resource group name.
     * @param shareName The name of the share.
     * @param skipToken Continuation token
     * @return List response for get ShareSynchronization.
     */
    public suspend fun listShareSynchronizations(
        accountName: String,
        filter: String? = null,
        orderby: String? = null,
        resourceGroupName: String,
        shareName: String,
        skipToken: String? = null,
    ): ListShareSynchronizationsResult {
        val argument = ListShareSynchronizationsPlainArgs(
            accountName = accountName,
            filter = filter,
            orderby = orderby,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
            skipToken = skipToken,
        )
        return listShareSynchronizationsResultToKotlin(listShareSynchronizationsPlain(argument.toJava()).await())
    }

    /**
     * @see [listShareSynchronizations].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datashare&#46;kotlin&#46;inputs&#46;ListShareSynchronizationsPlainArgs].
     * @return List response for get ShareSynchronization.
     */
    public suspend fun listShareSynchronizations(argument: suspend ListShareSynchronizationsPlainArgsBuilder.() -> Unit): ListShareSynchronizationsResult {
        val builder = ListShareSynchronizationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listShareSynchronizationsResultToKotlin(listShareSynchronizationsPlain(builtArgument.toJava()).await())
    }
}
