@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.ScheduledSynchronizationSettingArgs.builder
import com.pulumi.azurenative.datashare.kotlin.enums.RecurrenceInterval
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A type of synchronization setting based on schedule
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### SynchronizationSettings_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledSynchronizationSetting = new AzureNative.DataShare.ScheduledSynchronizationSetting("scheduledSynchronizationSetting", new()
 *     {
 *         AccountName = "Account1",
 *         Kind = "ScheduleBased",
 *         RecurrenceInterval = AzureNative.DataShare.RecurrenceInterval.Day,
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *         SynchronizationSettingName = "Dataset1",
 *         SynchronizationTime = "2018-11-14T04:47:52.9614956Z",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewScheduledSynchronizationSetting(ctx, "scheduledSynchronizationSetting", &datashare.ScheduledSynchronizationSettingArgs{
 * 			AccountName:                pulumi.String("Account1"),
 * 			Kind:                       pulumi.String("ScheduleBased"),
 * 			RecurrenceInterval:         pulumi.String(datashare.RecurrenceIntervalDay),
 * 			ResourceGroupName:          pulumi.String("SampleResourceGroup"),
 * 			ShareName:                  pulumi.String("Share1"),
 * 			SynchronizationSettingName: pulumi.String("Dataset1"),
 * 			SynchronizationTime:        pulumi.String("2018-11-14T04:47:52.9614956Z"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ScheduledSynchronizationSetting;
 * import com.pulumi.azurenative.datashare.ScheduledSynchronizationSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledSynchronizationSetting = new ScheduledSynchronizationSetting("scheduledSynchronizationSetting", ScheduledSynchronizationSettingArgs.builder()
 *             .accountName("Account1")
 *             .kind("ScheduleBased")
 *             .recurrenceInterval("Day")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .synchronizationSettingName("Dataset1")
 *             .synchronizationTime("2018-11-14T04:47:52.9614956Z")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:ScheduledSynchronizationSetting SynchronizationSetting1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/synchronizationSettings/{synchronizationSettingName}
 * ```
 * @property accountName The name of the share account.
 * @property kind Kind of synchronization setting.
 * Expected value is 'ScheduleBased'.
 * @property recurrenceInterval Recurrence Interval
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share to add the synchronization setting to.
 * @property synchronizationSettingName The name of the synchronizationSetting.
 * @property synchronizationTime Synchronization time
 */
public data class ScheduledSynchronizationSettingArgs(
    public val accountName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val recurrenceInterval: Output<Either<String, RecurrenceInterval>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareName: Output<String>? = null,
    public val synchronizationSettingName: Output<String>? = null,
    public val synchronizationTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.ScheduledSynchronizationSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.ScheduledSynchronizationSettingArgs =
        com.pulumi.azurenative.datashare.ScheduledSynchronizationSettingArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .recurrenceInterval(
                recurrenceInterval?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareName(shareName?.applyValue({ args0 -> args0 }))
            .synchronizationSettingName(synchronizationSettingName?.applyValue({ args0 -> args0 }))
            .synchronizationTime(synchronizationTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduledSynchronizationSettingArgs].
 */
@PulumiTagMarker
public class ScheduledSynchronizationSettingArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var kind: Output<String>? = null

    private var recurrenceInterval: Output<Either<String, RecurrenceInterval>>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareName: Output<String>? = null

    private var synchronizationSettingName: Output<String>? = null

    private var synchronizationTime: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("goftkxdgveyjighj")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Kind of synchronization setting.
     * Expected value is 'ScheduleBased'.
     */
    @JvmName("weepjssdaddvbjsu")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Recurrence Interval
     */
    @JvmName("dfsopnuxgyxruqcf")
    public suspend fun recurrenceInterval(`value`: Output<Either<String, RecurrenceInterval>>) {
        this.recurrenceInterval = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("wgtqwlanbqipninw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the share to add the synchronization setting to.
     */
    @JvmName("bntblsadbnfttdpf")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value The name of the synchronizationSetting.
     */
    @JvmName("ssuenoydrfucrkal")
    public suspend fun synchronizationSettingName(`value`: Output<String>) {
        this.synchronizationSettingName = value
    }

    /**
     * @param value Synchronization time
     */
    @JvmName("urdpjookwkxhjdcp")
    public suspend fun synchronizationTime(`value`: Output<String>) {
        this.synchronizationTime = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("godxiclbmgkwtnjs")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Kind of synchronization setting.
     * Expected value is 'ScheduleBased'.
     */
    @JvmName("gewdppuaywwmapvq")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Recurrence Interval
     */
    @JvmName("axtxbskgvuilgpym")
    public suspend fun recurrenceInterval(`value`: Either<String, RecurrenceInterval>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrenceInterval = mapped
    }

    /**
     * @param value Recurrence Interval
     */
    @JvmName("morfstsqcgqfnapd")
    public fun recurrenceInterval(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecurrenceInterval>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceInterval = mapped
    }

    /**
     * @param value Recurrence Interval
     */
    @JvmName("vupaqteovvvgwcap")
    public fun recurrenceInterval(`value`: RecurrenceInterval) {
        val toBeMapped = Either.ofRight<String, RecurrenceInterval>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceInterval = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("bogswnoicdcnuirq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share to add the synchronization setting to.
     */
    @JvmName("xjmkkaqdrtjdcjpf")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value The name of the synchronizationSetting.
     */
    @JvmName("ghpyedfbyxdpqmgy")
    public suspend fun synchronizationSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synchronizationSettingName = mapped
    }

    /**
     * @param value Synchronization time
     */
    @JvmName("ipclorpqrixyvykr")
    public suspend fun synchronizationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synchronizationTime = mapped
    }

    internal fun build(): ScheduledSynchronizationSettingArgs = ScheduledSynchronizationSettingArgs(
        accountName = accountName,
        kind = kind,
        recurrenceInterval = recurrenceInterval,
        resourceGroupName = resourceGroupName,
        shareName = shareName,
        synchronizationSettingName = synchronizationSettingName,
        synchronizationTime = synchronizationTime,
    )
}
