@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.ShareSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A share subscription data transfer object.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2018-11-01-preview.
 * ## Example Usage
 * ### ShareSubscriptions_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var shareSubscription = new AzureNative.DataShare.ShareSubscription("shareSubscription", new()
 *     {
 *         AccountName = "Account1",
 *         ExpirationDate = "2020-08-26T22:33:24.5785265Z",
 *         InvitationId = "12345678-1234-1234-12345678abd",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *         SourceShareLocation = "eastus2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewShareSubscription(ctx, "shareSubscription", &datashare.ShareSubscriptionArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			ExpirationDate:        pulumi.String("2020-08-26T22:33:24.5785265Z"),
 * 			InvitationId:          pulumi.String("12345678-1234-1234-12345678abd"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 			SourceShareLocation:   pulumi.String("eastus2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ShareSubscription;
 * import com.pulumi.azurenative.datashare.ShareSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var shareSubscription = new ShareSubscription("shareSubscription", ShareSubscriptionArgs.builder()
 *             .accountName("Account1")
 *             .expirationDate("2020-08-26T22:33:24.5785265Z")
 *             .invitationId("12345678-1234-1234-12345678abd")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .sourceShareLocation("eastus2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:ShareSubscription ShareSubscription1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}
 * ```
 * @property accountName The name of the share account.
 * @property expirationDate The expiration date of the share subscription.
 * @property invitationId The invitation id.
 * @property resourceGroupName The resource group name.
 * @property shareSubscriptionName The name of the shareSubscription.
 * @property sourceShareLocation Source share location.
 */
public data class ShareSubscriptionArgs(
    public val accountName: Output<String>? = null,
    public val expirationDate: Output<String>? = null,
    public val invitationId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareSubscriptionName: Output<String>? = null,
    public val sourceShareLocation: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.ShareSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.ShareSubscriptionArgs =
        com.pulumi.azurenative.datashare.ShareSubscriptionArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .expirationDate(expirationDate?.applyValue({ args0 -> args0 }))
            .invitationId(invitationId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareSubscriptionName(shareSubscriptionName?.applyValue({ args0 -> args0 }))
            .sourceShareLocation(sourceShareLocation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ShareSubscriptionArgs].
 */
@PulumiTagMarker
public class ShareSubscriptionArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var expirationDate: Output<String>? = null

    private var invitationId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareSubscriptionName: Output<String>? = null

    private var sourceShareLocation: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("dbuirnlfyjrgbnpl")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The expiration date of the share subscription.
     */
    @JvmName("dsvicyiuelallmpe")
    public suspend fun expirationDate(`value`: Output<String>) {
        this.expirationDate = value
    }

    /**
     * @param value The invitation id.
     */
    @JvmName("uxqxxabnielnnsii")
    public suspend fun invitationId(`value`: Output<String>) {
        this.invitationId = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("cameiypqhxyasosp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the shareSubscription.
     */
    @JvmName("knakvsbtvwblgxrp")
    public suspend fun shareSubscriptionName(`value`: Output<String>) {
        this.shareSubscriptionName = value
    }

    /**
     * @param value Source share location.
     */
    @JvmName("icqcriidmupepcom")
    public suspend fun sourceShareLocation(`value`: Output<String>) {
        this.sourceShareLocation = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("coapffiaeqhyyapm")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The expiration date of the share subscription.
     */
    @JvmName("hdedqmgfmicoraky")
    public suspend fun expirationDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationDate = mapped
    }

    /**
     * @param value The invitation id.
     */
    @JvmName("pmbmtefakjgmplht")
    public suspend fun invitationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invitationId = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("nwqedyhwdwaycsid")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the shareSubscription.
     */
    @JvmName("ewpogfctrotphjbb")
    public suspend fun shareSubscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareSubscriptionName = mapped
    }

    /**
     * @param value Source share location.
     */
    @JvmName("dwjsetnbywnqhjyd")
    public suspend fun sourceShareLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceShareLocation = mapped
    }

    internal fun build(): ShareSubscriptionArgs = ShareSubscriptionArgs(
        accountName = accountName,
        expirationDate = expirationDate,
        invitationId = invitationId,
        resourceGroupName = resourceGroupName,
        shareSubscriptionName = shareSubscriptionName,
        sourceShareLocation = sourceShareLocation,
    )
}
