@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A Synapse Workspace Sql Pool Table data set.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSets_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var synapseWorkspaceSqlPoolTableDataSet = new AzureNative.DataShare.SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSynapseWorkspaceSqlPoolTableDataSet(ctx, "synapseWorkspaceSqlPoolTableDataSet", &datashare.SynapseWorkspaceSqlPoolTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSet;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var synapseWorkspaceSqlPoolTableDataSet = new SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", SynapseWorkspaceSqlPoolTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoCluster_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var synapseWorkspaceSqlPoolTableDataSet = new AzureNative.DataShare.SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSynapseWorkspaceSqlPoolTableDataSet(ctx, "synapseWorkspaceSqlPoolTableDataSet", &datashare.SynapseWorkspaceSqlPoolTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSet;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var synapseWorkspaceSqlPoolTableDataSet = new SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", SynapseWorkspaceSqlPoolTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoDatabase_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var synapseWorkspaceSqlPoolTableDataSet = new AzureNative.DataShare.SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSynapseWorkspaceSqlPoolTableDataSet(ctx, "synapseWorkspaceSqlPoolTableDataSet", &datashare.SynapseWorkspaceSqlPoolTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSet;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var synapseWorkspaceSqlPoolTableDataSet = new SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", SynapseWorkspaceSqlPoolTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var synapseWorkspaceSqlPoolTableDataSet = new AzureNative.DataShare.SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSynapseWorkspaceSqlPoolTableDataSet(ctx, "synapseWorkspaceSqlPoolTableDataSet", &datashare.SynapseWorkspaceSqlPoolTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSet;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var synapseWorkspaceSqlPoolTableDataSet = new SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", SynapseWorkspaceSqlPoolTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDBTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var synapseWorkspaceSqlPoolTableDataSet = new AzureNative.DataShare.SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSynapseWorkspaceSqlPoolTableDataSet(ctx, "synapseWorkspaceSqlPoolTableDataSet", &datashare.SynapseWorkspaceSqlPoolTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSet;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var synapseWorkspaceSqlPoolTableDataSet = new SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", SynapseWorkspaceSqlPoolTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDWTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var synapseWorkspaceSqlPoolTableDataSet = new AzureNative.DataShare.SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSynapseWorkspaceSqlPoolTableDataSet(ctx, "synapseWorkspaceSqlPoolTableDataSet", &datashare.SynapseWorkspaceSqlPoolTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSet;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var synapseWorkspaceSqlPoolTableDataSet = new SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", SynapseWorkspaceSqlPoolTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var synapseWorkspaceSqlPoolTableDataSet = new AzureNative.DataShare.SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", new()
 *     {
 *         AccountName = "sourceAccount",
 *         DataSetName = "dataset1",
 *         Kind = "SynapseWorkspaceSqlPoolTable",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "share1",
 *         SynapseWorkspaceSqlPoolTableResourceId = "/subscriptions/0f3dcfc3-18f8-4099-b381-8353e19d43a7/resourceGroups/SampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspace/sqlPools/ExampleSqlPool/schemas/dbo/tables/table1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSynapseWorkspaceSqlPoolTableDataSet(ctx, "synapseWorkspaceSqlPoolTableDataSet", &datashare.SynapseWorkspaceSqlPoolTableDataSetArgs{
 * 			AccountName:                            pulumi.String("sourceAccount"),
 * 			DataSetName:                            pulumi.String("dataset1"),
 * 			Kind:                                   pulumi.String("SynapseWorkspaceSqlPoolTable"),
 * 			ResourceGroupName:                      pulumi.String("SampleResourceGroup"),
 * 			ShareName:                              pulumi.String("share1"),
 * 			SynapseWorkspaceSqlPoolTableResourceId: pulumi.String("/subscriptions/0f3dcfc3-18f8-4099-b381-8353e19d43a7/resourceGroups/SampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspace/sqlPools/ExampleSqlPool/schemas/dbo/tables/table1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSet;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var synapseWorkspaceSqlPoolTableDataSet = new SynapseWorkspaceSqlPoolTableDataSet("synapseWorkspaceSqlPoolTableDataSet", SynapseWorkspaceSqlPoolTableDataSetArgs.builder()
 *             .accountName("sourceAccount")
 *             .dataSetName("dataset1")
 *             .kind("SynapseWorkspaceSqlPoolTable")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("share1")
 *             .synapseWorkspaceSqlPoolTableResourceId("/subscriptions/0f3dcfc3-18f8-4099-b381-8353e19d43a7/resourceGroups/SampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspace/sqlPools/ExampleSqlPool/schemas/dbo/tables/table1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:SynapseWorkspaceSqlPoolTableDataSet dataset1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/dataSets/{dataSetName}
 * ```
 * @property accountName The name of the share account.
 * @property dataSetName The name of the dataSet.
 * @property kind Kind of data set.
 * Expected value is 'SynapseWorkspaceSqlPoolTable'.
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share to add the data set to.
 * @property synapseWorkspaceSqlPoolTableResourceId Resource id of the Synapse Workspace SQL Pool Table
 */
public data class SynapseWorkspaceSqlPoolTableDataSetArgs(
    public val accountName: Output<String>? = null,
    public val dataSetName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareName: Output<String>? = null,
    public val synapseWorkspaceSqlPoolTableResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetArgs =
        com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .dataSetName(dataSetName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareName(shareName?.applyValue({ args0 -> args0 }))
            .synapseWorkspaceSqlPoolTableResourceId(
                synapseWorkspaceSqlPoolTableResourceId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [SynapseWorkspaceSqlPoolTableDataSetArgs].
 */
@PulumiTagMarker
public class SynapseWorkspaceSqlPoolTableDataSetArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var dataSetName: Output<String>? = null

    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareName: Output<String>? = null

    private var synapseWorkspaceSqlPoolTableResourceId: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("segfwlhdfpfnbyxy")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("stgissubgkdtlgpr")
    public suspend fun dataSetName(`value`: Output<String>) {
        this.dataSetName = value
    }

    /**
     * @param value Kind of data set.
     * Expected value is 'SynapseWorkspaceSqlPoolTable'.
     */
    @JvmName("ldbhltvmbnhmwpye")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("kfhcsdxbhymxbwih")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the share to add the data set to.
     */
    @JvmName("pifhmxyaxkaovkfx")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value Resource id of the Synapse Workspace SQL Pool Table
     */
    @JvmName("xtvhdxqhglijaslq")
    public suspend fun synapseWorkspaceSqlPoolTableResourceId(`value`: Output<String>) {
        this.synapseWorkspaceSqlPoolTableResourceId = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("oofbhxetjopwirlo")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("egtfgawnvjtmxoye")
    public suspend fun dataSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetName = mapped
    }

    /**
     * @param value Kind of data set.
     * Expected value is 'SynapseWorkspaceSqlPoolTable'.
     */
    @JvmName("aoetoiuyvckjxtik")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("wobrbleaykyeyoox")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share to add the data set to.
     */
    @JvmName("tfkvbmgkdyptvlep")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value Resource id of the Synapse Workspace SQL Pool Table
     */
    @JvmName("vbcebkvuniwukwvm")
    public suspend fun synapseWorkspaceSqlPoolTableResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synapseWorkspaceSqlPoolTableResourceId = mapped
    }

    internal fun build(): SynapseWorkspaceSqlPoolTableDataSetArgs =
        SynapseWorkspaceSqlPoolTableDataSetArgs(
            accountName = accountName,
            dataSetName = dataSetName,
            kind = kind,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
            synapseWorkspaceSqlPoolTableResourceId = synapseWorkspaceSqlPoolTableResourceId,
        )
}
