@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A Synapse Workspace Sql Pool Table data set mapping
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSetMappings_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var synapseWorkspaceSqlPoolTableDataSetMapping = new AzureNative.DataShare.SynapseWorkspaceSqlPoolTableDataSetMapping("synapseWorkspaceSqlPoolTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSynapseWorkspaceSqlPoolTableDataSetMapping(ctx, "synapseWorkspaceSqlPoolTableDataSetMapping", &datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var synapseWorkspaceSqlPoolTableDataSetMapping = new SynapseWorkspaceSqlPoolTableDataSetMapping("synapseWorkspaceSqlPoolTableDataSetMapping", SynapseWorkspaceSqlPoolTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDB_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var synapseWorkspaceSqlPoolTableDataSetMapping = new AzureNative.DataShare.SynapseWorkspaceSqlPoolTableDataSetMapping("synapseWorkspaceSqlPoolTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSynapseWorkspaceSqlPoolTableDataSetMapping(ctx, "synapseWorkspaceSqlPoolTableDataSetMapping", &datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var synapseWorkspaceSqlPoolTableDataSetMapping = new SynapseWorkspaceSqlPoolTableDataSetMapping("synapseWorkspaceSqlPoolTableDataSetMapping", SynapseWorkspaceSqlPoolTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDWDataSetToAdlsGen2File_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var synapseWorkspaceSqlPoolTableDataSetMapping = new AzureNative.DataShare.SynapseWorkspaceSqlPoolTableDataSetMapping("synapseWorkspaceSqlPoolTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSynapseWorkspaceSqlPoolTableDataSetMapping(ctx, "synapseWorkspaceSqlPoolTableDataSetMapping", &datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var synapseWorkspaceSqlPoolTableDataSetMapping = new SynapseWorkspaceSqlPoolTableDataSetMapping("synapseWorkspaceSqlPoolTableDataSetMapping", SynapseWorkspaceSqlPoolTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDW_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var synapseWorkspaceSqlPoolTableDataSetMapping = new AzureNative.DataShare.SynapseWorkspaceSqlPoolTableDataSetMapping("synapseWorkspaceSqlPoolTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSynapseWorkspaceSqlPoolTableDataSetMapping(ctx, "synapseWorkspaceSqlPoolTableDataSetMapping", &datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var synapseWorkspaceSqlPoolTableDataSetMapping = new SynapseWorkspaceSqlPoolTableDataSetMapping("synapseWorkspaceSqlPoolTableDataSetMapping", SynapseWorkspaceSqlPoolTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var synapseWorkspaceSqlPoolTableDataSetMapping = new AzureNative.DataShare.SynapseWorkspaceSqlPoolTableDataSetMapping("synapseWorkspaceSqlPoolTableDataSetMapping", new()
 *     {
 *         AccountName = "consumerAccount",
 *         DataSetId = "3dc64e49-1fc3-4186-b3dc-d388c4d3076a",
 *         DataSetMappingName = "datasetMappingName1",
 *         Kind = "SynapseWorkspaceSqlPoolTable",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *         SynapseWorkspaceSqlPoolTableResourceId = "/subscriptions/0f3dcfc3-18f8-4099-b381-8353e19d43a7/resourceGroups/SampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspace/sqlPools/ExampleSqlPool/schemas/dbo/tables/table1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSynapseWorkspaceSqlPoolTableDataSetMapping(ctx, "synapseWorkspaceSqlPoolTableDataSetMapping", &datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs{
 * 			AccountName:                            pulumi.String("consumerAccount"),
 * 			DataSetId:                              pulumi.String("3dc64e49-1fc3-4186-b3dc-d388c4d3076a"),
 * 			DataSetMappingName:                     pulumi.String("datasetMappingName1"),
 * 			Kind:                                   pulumi.String("SynapseWorkspaceSqlPoolTable"),
 * 			ResourceGroupName:                      pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName:                  pulumi.String("ShareSubscription1"),
 * 			SynapseWorkspaceSqlPoolTableResourceId: pulumi.String("/subscriptions/0f3dcfc3-18f8-4099-b381-8353e19d43a7/resourceGroups/SampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspace/sqlPools/ExampleSqlPool/schemas/dbo/tables/table1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var synapseWorkspaceSqlPoolTableDataSetMapping = new SynapseWorkspaceSqlPoolTableDataSetMapping("synapseWorkspaceSqlPoolTableDataSetMapping", SynapseWorkspaceSqlPoolTableDataSetMappingArgs.builder()
 *             .accountName("consumerAccount")
 *             .dataSetId("3dc64e49-1fc3-4186-b3dc-d388c4d3076a")
 *             .dataSetMappingName("datasetMappingName1")
 *             .kind("SynapseWorkspaceSqlPoolTable")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .synapseWorkspaceSqlPoolTableResourceId("/subscriptions/0f3dcfc3-18f8-4099-b381-8353e19d43a7/resourceGroups/SampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspace/sqlPools/ExampleSqlPool/schemas/dbo/tables/table1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:SynapseWorkspaceSqlPoolTableDataSetMapping datasetMappingName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/dataSetMappings/{dataSetMappingName}
 * ```
 * @property accountName The name of the share account.
 * @property dataSetId The id of the source data set.
 * @property dataSetMappingName The name of the data set mapping to be created.
 * @property kind Kind of data set mapping.
 * Expected value is 'SynapseWorkspaceSqlPoolTable'.
 * @property resourceGroupName The resource group name.
 * @property shareSubscriptionName The name of the share subscription which will hold the data set sink.
 * @property synapseWorkspaceSqlPoolTableResourceId Resource id of the Synapse Workspace SQL Pool Table
 */
public data class SynapseWorkspaceSqlPoolTableDataSetMappingArgs(
    public val accountName: Output<String>? = null,
    public val dataSetId: Output<String>? = null,
    public val dataSetMappingName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareSubscriptionName: Output<String>? = null,
    public val synapseWorkspaceSqlPoolTableResourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs =
        com.pulumi.azurenative.datashare.SynapseWorkspaceSqlPoolTableDataSetMappingArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .dataSetId(dataSetId?.applyValue({ args0 -> args0 }))
            .dataSetMappingName(dataSetMappingName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareSubscriptionName(shareSubscriptionName?.applyValue({ args0 -> args0 }))
            .synapseWorkspaceSqlPoolTableResourceId(
                synapseWorkspaceSqlPoolTableResourceId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [SynapseWorkspaceSqlPoolTableDataSetMappingArgs].
 */
@PulumiTagMarker
public class SynapseWorkspaceSqlPoolTableDataSetMappingArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var dataSetId: Output<String>? = null

    private var dataSetMappingName: Output<String>? = null

    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareSubscriptionName: Output<String>? = null

    private var synapseWorkspaceSqlPoolTableResourceId: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("ohafpkbilsydfnnt")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The id of the source data set.
     */
    @JvmName("byvjnchcbrqsrenv")
    public suspend fun dataSetId(`value`: Output<String>) {
        this.dataSetId = value
    }

    /**
     * @param value The name of the data set mapping to be created.
     */
    @JvmName("yihnmbxdowsmcrvm")
    public suspend fun dataSetMappingName(`value`: Output<String>) {
        this.dataSetMappingName = value
    }

    /**
     * @param value Kind of data set mapping.
     * Expected value is 'SynapseWorkspaceSqlPoolTable'.
     */
    @JvmName("otwrwinkxgvywwxa")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("jehookiacrdqqyxk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the share subscription which will hold the data set sink.
     */
    @JvmName("uecmpavscscdkdoh")
    public suspend fun shareSubscriptionName(`value`: Output<String>) {
        this.shareSubscriptionName = value
    }

    /**
     * @param value Resource id of the Synapse Workspace SQL Pool Table
     */
    @JvmName("eonbhuvgtxbkmwwk")
    public suspend fun synapseWorkspaceSqlPoolTableResourceId(`value`: Output<String>) {
        this.synapseWorkspaceSqlPoolTableResourceId = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("edrvsjxlbdmxyjio")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The id of the source data set.
     */
    @JvmName("huhrbbggcsnbqmwb")
    public suspend fun dataSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetId = mapped
    }

    /**
     * @param value The name of the data set mapping to be created.
     */
    @JvmName("vekkbsjnrqwkutvm")
    public suspend fun dataSetMappingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetMappingName = mapped
    }

    /**
     * @param value Kind of data set mapping.
     * Expected value is 'SynapseWorkspaceSqlPoolTable'.
     */
    @JvmName("rqonsbpduajkbfpc")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("foykyxvelnqiatpd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share subscription which will hold the data set sink.
     */
    @JvmName("ndnyyqnvnvefaahc")
    public suspend fun shareSubscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareSubscriptionName = mapped
    }

    /**
     * @param value Resource id of the Synapse Workspace SQL Pool Table
     */
    @JvmName("gffavdefdtmacuil")
    public suspend fun synapseWorkspaceSqlPoolTableResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synapseWorkspaceSqlPoolTableResourceId = mapped
    }

    internal fun build(): SynapseWorkspaceSqlPoolTableDataSetMappingArgs =
        SynapseWorkspaceSqlPoolTableDataSetMappingArgs(
            accountName = accountName,
            dataSetId = dataSetId,
            dataSetMappingName = dataSetMappingName,
            kind = kind,
            resourceGroupName = resourceGroupName,
            shareSubscriptionName = shareSubscriptionName,
            synapseWorkspaceSqlPoolTableResourceId = synapseWorkspaceSqlPoolTableResourceId,
        )
}
