@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.ListShareSynchronizationDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the share account.
 * @property consumerEmail Email of the user who created the synchronization
 * @property consumerName Name of the user who created the synchronization
 * @property consumerTenantName Tenant name of the consumer who created the synchronization
 * @property durationMs synchronization duration
 * @property endTime End time of synchronization
 * @property filter Filters the results using OData syntax.
 * @property message message of synchronization
 * @property orderby Sorts the results using OData syntax.
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share.
 * @property skipToken Continuation token
 * @property startTime start time of synchronization
 * @property status Raw Status
 * @property synchronizationId Synchronization id
 */
public data class ListShareSynchronizationDetailsPlainArgs(
    public val accountName: String,
    public val consumerEmail: String? = null,
    public val consumerName: String? = null,
    public val consumerTenantName: String? = null,
    public val durationMs: Int? = null,
    public val endTime: String? = null,
    public val filter: String? = null,
    public val message: String? = null,
    public val orderby: String? = null,
    public val resourceGroupName: String,
    public val shareName: String,
    public val skipToken: String? = null,
    public val startTime: String? = null,
    public val status: String? = null,
    public val synchronizationId: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.ListShareSynchronizationDetailsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.inputs.ListShareSynchronizationDetailsPlainArgs =
        com.pulumi.azurenative.datashare.inputs.ListShareSynchronizationDetailsPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .consumerEmail(consumerEmail?.let({ args0 -> args0 }))
            .consumerName(consumerName?.let({ args0 -> args0 }))
            .consumerTenantName(consumerTenantName?.let({ args0 -> args0 }))
            .durationMs(durationMs?.let({ args0 -> args0 }))
            .endTime(endTime?.let({ args0 -> args0 }))
            .filter(filter?.let({ args0 -> args0 }))
            .message(message?.let({ args0 -> args0 }))
            .orderby(orderby?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .shareName(shareName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 }))
            .startTime(startTime?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .synchronizationId(synchronizationId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListShareSynchronizationDetailsPlainArgs].
 */
@PulumiTagMarker
public class ListShareSynchronizationDetailsPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var consumerEmail: String? = null

    private var consumerName: String? = null

    private var consumerTenantName: String? = null

    private var durationMs: Int? = null

    private var endTime: String? = null

    private var filter: String? = null

    private var message: String? = null

    private var orderby: String? = null

    private var resourceGroupName: String? = null

    private var shareName: String? = null

    private var skipToken: String? = null

    private var startTime: String? = null

    private var status: String? = null

    private var synchronizationId: String? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("vnmedmnkfojmrqlw")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Email of the user who created the synchronization
     */
    @JvmName("fcmqkxacfcqaekal")
    public suspend fun consumerEmail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.consumerEmail = mapped
    }

    /**
     * @param value Name of the user who created the synchronization
     */
    @JvmName("btambssvcwpnmwxo")
    public suspend fun consumerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.consumerName = mapped
    }

    /**
     * @param value Tenant name of the consumer who created the synchronization
     */
    @JvmName("olgyrfddraprcyij")
    public suspend fun consumerTenantName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.consumerTenantName = mapped
    }

    /**
     * @param value synchronization duration
     */
    @JvmName("msxishimcfokhdpk")
    public suspend fun durationMs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.durationMs = mapped
    }

    /**
     * @param value End time of synchronization
     */
    @JvmName("bqtlditeapwwdtvt")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endTime = mapped
    }

    /**
     * @param value Filters the results using OData syntax.
     */
    @JvmName("dgccdbptajeecpet")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filter = mapped
    }

    /**
     * @param value message of synchronization
     */
    @JvmName("jglyxtqnchpharxj")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.message = mapped
    }

    /**
     * @param value Sorts the results using OData syntax.
     */
    @JvmName("hscywxxtjdmudnij")
    public suspend fun orderby(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderby = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("awxuagpvqbkifluu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share.
     */
    @JvmName("vsubamcxsbhgjgcc")
    public suspend fun shareName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareName = mapped
    }

    /**
     * @param value Continuation token
     */
    @JvmName("xdppkinquiasliip")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    /**
     * @param value start time of synchronization
     */
    @JvmName("nrcikiilwtuahkxv")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startTime = mapped
    }

    /**
     * @param value Raw Status
     */
    @JvmName("sabscxxnggebvwas")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value Synchronization id
     */
    @JvmName("fobkymymtafbmlyw")
    public suspend fun synchronizationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.synchronizationId = mapped
    }

    internal fun build(): ListShareSynchronizationDetailsPlainArgs =
        ListShareSynchronizationDetailsPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            consumerEmail = consumerEmail,
            consumerName = consumerName,
            consumerTenantName = consumerTenantName,
            durationMs = durationMs,
            endTime = endTime,
            filter = filter,
            message = message,
            orderby = orderby,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            shareName = shareName ?: throw PulumiNullFieldException("shareName"),
            skipToken = skipToken,
            startTime = startTime,
            status = status,
            synchronizationId = synchronizationId,
        )
}
