@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An ADLS Gen 1 file data set.
 * @property accountName The ADLS account name.
 * @property dataSetId Unique id for identifying a data set resource
 * @property fileName The file name in the ADLS account.
 * @property folderPath The folder path within the ADLS account.
 * @property id The resource id of the azure resource
 * @property kind Kind of data set.
 * Expected value is 'AdlsGen1File'.
 * @property name Name of the azure resource
 * @property resourceGroup Resource group of ADLS account.
 * @property subscriptionId Subscription id of ADLS account.
 * @property systemData System Data of the Azure resource.
 * @property type Type of the azure resource
 */
public data class GetADLSGen1FileDataSetResult(
    public val accountName: String,
    public val dataSetId: String,
    public val fileName: String,
    public val folderPath: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val resourceGroup: String,
    public val subscriptionId: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetADLSGen1FileDataSetResult): GetADLSGen1FileDataSetResult = GetADLSGen1FileDataSetResult(
            accountName = javaType.accountName(),
            dataSetId = javaType.dataSetId(),
            fileName = javaType.fileName(),
            folderPath = javaType.folderPath(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            resourceGroup = javaType.resourceGroup(),
            subscriptionId = javaType.subscriptionId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
