@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An account data transfer object.
 * @property createdAt Time at which the account was created.
 * @property id The resource id of the azure resource
 * @property identity Identity Info on the Account
 * @property location Location of the azure resource.
 * @property name Name of the azure resource
 * @property provisioningState Provisioning state of the Account
 * @property systemData System Data of the Azure resource.
 * @property tags Tags on the azure resource.
 * @property type Type of the azure resource
 * @property userEmail Email of the user who created the resource
 * @property userName Name of the user who created the resource
 */
public data class GetAccountResult(
    public val createdAt: String,
    public val id: String,
    public val identity: IdentityResponse,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val userEmail: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetAccountResult): GetAccountResult = GetAccountResult(
            createdAt = javaType.createdAt(),
            id = javaType.id(),
            identity = javaType.identity().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userEmail = javaType.userEmail(),
            userName = javaType.userName(),
        )
    }
}
