@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Azure storage blob container data set.
 * @property containerName BLOB Container name.
 * @property dataSetId Unique id for identifying a data set resource
 * @property id The resource id of the azure resource
 * @property kind Kind of data set.
 * Expected value is 'Container'.
 * @property name Name of the azure resource
 * @property resourceGroup Resource group of storage account
 * @property storageAccountName Storage account name of the source data set
 * @property subscriptionId Subscription id of storage account
 * @property systemData System Data of the Azure resource.
 * @property type Type of the azure resource
 */
public data class GetBlobContainerDataSetResult(
    public val containerName: String,
    public val dataSetId: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val resourceGroup: String,
    public val storageAccountName: String,
    public val subscriptionId: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetBlobContainerDataSetResult): GetBlobContainerDataSetResult = GetBlobContainerDataSetResult(
            containerName = javaType.containerName(),
            dataSetId = javaType.dataSetId(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            resourceGroup = javaType.resourceGroup(),
            storageAccountName = javaType.storageAccountName(),
            subscriptionId = javaType.subscriptionId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
