@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Azure storage blob folder data set.
 * @property containerName Container that has the file path.
 * @property dataSetId Unique id for identifying a data set resource
 * @property id The resource id of the azure resource
 * @property kind Kind of data set.
 * Expected value is 'BlobFolder'.
 * @property name Name of the azure resource
 * @property prefix Prefix for blob folder
 * @property resourceGroup Resource group of storage account
 * @property storageAccountName Storage account name of the source data set
 * @property subscriptionId Subscription id of storage account
 * @property systemData System Data of the Azure resource.
 * @property type Type of the azure resource
 */
public data class GetBlobFolderDataSetResult(
    public val containerName: String,
    public val dataSetId: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val prefix: String,
    public val resourceGroup: String,
    public val storageAccountName: String,
    public val subscriptionId: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetBlobFolderDataSetResult): GetBlobFolderDataSetResult = GetBlobFolderDataSetResult(
            containerName = javaType.containerName(),
            dataSetId = javaType.dataSetId(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            prefix = javaType.prefix(),
            resourceGroup = javaType.resourceGroup(),
            storageAccountName = javaType.storageAccountName(),
            subscriptionId = javaType.subscriptionId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
