@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A type of trigger based on schedule
 * @property createdAt Time at which the trigger was created.
 * @property id The resource id of the azure resource
 * @property kind Kind of synchronization on trigger.
 * Expected value is 'ScheduleBased'.
 * @property name Name of the azure resource
 * @property provisioningState Gets the provisioning state
 * @property recurrenceInterval Recurrence Interval
 * @property synchronizationMode Synchronization mode
 * @property synchronizationTime Synchronization time
 * @property systemData System Data of the Azure resource.
 * @property triggerStatus Gets the trigger state
 * @property type Type of the azure resource
 * @property userName Name of the user who created the trigger.
 */
public data class GetScheduledTriggerResult(
    public val createdAt: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val provisioningState: String,
    public val recurrenceInterval: String,
    public val synchronizationMode: String? = null,
    public val synchronizationTime: String,
    public val systemData: SystemDataResponse,
    public val triggerStatus: String,
    public val type: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetScheduledTriggerResult): GetScheduledTriggerResult = GetScheduledTriggerResult(
            createdAt = javaType.createdAt(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            recurrenceInterval = javaType.recurrenceInterval(),
            synchronizationMode = javaType.synchronizationMode().map({ args0 -> args0 }).orElse(null),
            synchronizationTime = javaType.synchronizationTime(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            triggerStatus = javaType.triggerStatus(),
            type = javaType.type(),
            userName = javaType.userName(),
        )
    }
}
