@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A share subscription data transfer object.
 * @property createdAt Time at which the share subscription was created.
 * @property expirationDate The expiration date of the share subscription.
 * @property id The resource id of the azure resource
 * @property invitationId The invitation id.
 * @property name Name of the azure resource
 * @property providerEmail Email of the provider who created the resource
 * @property providerName Name of the provider who created the resource
 * @property providerTenantName Tenant name of the provider who created the resource
 * @property provisioningState Provisioning state of the share subscription
 * @property shareDescription Description of share
 * @property shareKind Kind of share
 * @property shareName Name of the share
 * @property shareSubscriptionStatus Gets the current status of share subscription.
 * @property shareTerms Terms of a share
 * @property sourceShareLocation Source share location.
 * @property systemData System Data of the Azure resource.
 * @property type Type of the azure resource
 * @property userEmail Email of the user who created the resource
 * @property userName Name of the user who created the resource
 */
public data class GetShareSubscriptionResult(
    public val createdAt: String,
    public val expirationDate: String? = null,
    public val id: String,
    public val invitationId: String,
    public val name: String,
    public val providerEmail: String,
    public val providerName: String,
    public val providerTenantName: String,
    public val provisioningState: String,
    public val shareDescription: String,
    public val shareKind: String,
    public val shareName: String,
    public val shareSubscriptionStatus: String,
    public val shareTerms: String,
    public val sourceShareLocation: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val userEmail: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetShareSubscriptionResult): GetShareSubscriptionResult = GetShareSubscriptionResult(
            createdAt = javaType.createdAt(),
            expirationDate = javaType.expirationDate().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            invitationId = javaType.invitationId(),
            name = javaType.name(),
            providerEmail = javaType.providerEmail(),
            providerName = javaType.providerName(),
            providerTenantName = javaType.providerTenantName(),
            provisioningState = javaType.provisioningState(),
            shareDescription = javaType.shareDescription(),
            shareKind = javaType.shareKind(),
            shareName = javaType.shareName(),
            shareSubscriptionStatus = javaType.shareSubscriptionStatus(),
            shareTerms = javaType.shareTerms(),
            sourceShareLocation = javaType.sourceShareLocation(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            userEmail = javaType.userEmail(),
            userName = javaType.userName(),
        )
    }
}
