@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A SQL DB table data set.
 * @property dataSetId Unique id for identifying a data set resource
 * @property databaseName Database name of the source data set
 * @property id The resource id of the azure resource
 * @property kind Kind of data set.
 * Expected value is 'SqlDBTable'.
 * @property name Name of the azure resource
 * @property schemaName Schema of the table. Default value is dbo.
 * @property sqlServerResourceId Resource id of SQL server
 * @property systemData System Data of the Azure resource.
 * @property tableName SQL DB table name.
 * @property type Type of the azure resource
 */
public data class GetSqlDBTableDataSetResult(
    public val dataSetId: String,
    public val databaseName: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val schemaName: String,
    public val sqlServerResourceId: String,
    public val systemData: SystemDataResponse,
    public val tableName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetSqlDBTableDataSetResult): GetSqlDBTableDataSetResult = GetSqlDBTableDataSetResult(
            dataSetId = javaType.dataSetId(),
            databaseName = javaType.databaseName(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            schemaName = javaType.schemaName(),
            sqlServerResourceId = javaType.sqlServerResourceId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tableName = javaType.tableName(),
            type = javaType.type(),
        )
    }
}
