@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A Synapse Workspace Sql Pool Table data set mapping
 * @property dataSetId The id of the source data set.
 * @property dataSetMappingStatus Gets the status of the data set mapping.
 * @property id The resource id of the azure resource
 * @property kind Kind of data set mapping.
 * Expected value is 'SynapseWorkspaceSqlPoolTable'.
 * @property name Name of the azure resource
 * @property provisioningState Provisioning state of the data set mapping.
 * @property synapseWorkspaceSqlPoolTableResourceId Resource id of the Synapse Workspace SQL Pool Table
 * @property systemData System Data of the Azure resource.
 * @property type Type of the azure resource
 */
public data class GetSynapseWorkspaceSqlPoolTableDataSetMappingResult(
    public val dataSetId: String,
    public val dataSetMappingStatus: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val provisioningState: String,
    public val synapseWorkspaceSqlPoolTableResourceId: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetSynapseWorkspaceSqlPoolTableDataSetMappingResult): GetSynapseWorkspaceSqlPoolTableDataSetMappingResult =
            GetSynapseWorkspaceSqlPoolTableDataSetMappingResult(
                dataSetId = javaType.dataSetId(),
                dataSetMappingStatus = javaType.dataSetMappingStatus(),
                id = javaType.id(),
                kind = javaType.kind(),
                name = javaType.name(),
                provisioningState = javaType.provisioningState(),
                synapseWorkspaceSqlPoolTableResourceId = javaType.synapseWorkspaceSqlPoolTableResourceId(),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                type = javaType.type(),
            )
    }
}
