@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * List response for get ShareSynchronization.
 * @property nextLink The Url of next result page.
 * @property value Collection of items of type DataTransferObjects.
 */
public data class ListShareSynchronizationsResult(
    public val nextLink: String? = null,
    public val `value`: List<ShareSynchronizationResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.ListShareSynchronizationsResult): ListShareSynchronizationsResult = ListShareSynchronizationsResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datashare.kotlin.outputs.ShareSynchronizationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
