@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A ShareSynchronization data transfer object.
 * @property consumerEmail Email of the user who created the synchronization
 * @property consumerName Name of the user who created the synchronization
 * @property consumerTenantName Tenant name of the consumer who created the synchronization
 * @property durationMs synchronization duration
 * @property endTime End time of synchronization
 * @property message message of synchronization
 * @property startTime start time of synchronization
 * @property status Raw Status
 * @property synchronizationId Synchronization id
 * @property synchronizationMode Synchronization mode
 */
public data class ShareSynchronizationResponse(
    public val consumerEmail: String? = null,
    public val consumerName: String? = null,
    public val consumerTenantName: String? = null,
    public val durationMs: Int? = null,
    public val endTime: String? = null,
    public val message: String? = null,
    public val startTime: String? = null,
    public val status: String? = null,
    public val synchronizationId: String? = null,
    public val synchronizationMode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.ShareSynchronizationResponse): ShareSynchronizationResponse = ShareSynchronizationResponse(
            consumerEmail = javaType.consumerEmail().map({ args0 -> args0 }).orElse(null),
            consumerName = javaType.consumerName().map({ args0 -> args0 }).orElse(null),
            consumerTenantName = javaType.consumerTenantName().map({ args0 -> args0 }).orElse(null),
            durationMs = javaType.durationMs().map({ args0 -> args0 }).orElse(null),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            synchronizationId = javaType.synchronizationId().map({ args0 -> args0 }).orElse(null),
            synchronizationMode = javaType.synchronizationMode(),
        )
    }
}
