@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Table level sharing properties dto for kusto data set properties
 * @property externalTablesToExclude External tables to be excluded in the data set
 * @property externalTablesToInclude External tables to be included in the data set
 * @property materializedViewsToExclude Materialized views to be excluded in the data set
 * @property materializedViewsToInclude Materialized views to be included in the data set
 * @property tablesToExclude Tables to be excluded in the data set
 * @property tablesToInclude Tables to be included in the data set
 */
public data class TableLevelSharingPropertiesResponse(
    public val externalTablesToExclude: List<String>? = null,
    public val externalTablesToInclude: List<String>? = null,
    public val materializedViewsToExclude: List<String>? = null,
    public val materializedViewsToInclude: List<String>? = null,
    public val tablesToExclude: List<String>? = null,
    public val tablesToInclude: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.TableLevelSharingPropertiesResponse): TableLevelSharingPropertiesResponse = TableLevelSharingPropertiesResponse(
            externalTablesToExclude = javaType.externalTablesToExclude().map({ args0 -> args0 }),
            externalTablesToInclude = javaType.externalTablesToInclude().map({ args0 -> args0 }),
            materializedViewsToExclude = javaType.materializedViewsToExclude().map({ args0 -> args0 }),
            materializedViewsToInclude = javaType.materializedViewsToInclude().map({ args0 -> args0 }),
            tablesToExclude = javaType.tablesToExclude().map({ args0 -> args0 }),
            tablesToInclude = javaType.tablesToInclude().map({ args0 -> args0 }),
        )
    }
}
