@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin

import com.pulumi.azurenative.dbformariadb.DatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a Database.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * Other available API versions: 2018-06-01-preview.
 * ## Example Usage
 * ### DatabaseCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.DBforMariaDB.Database("database", new()
 *     {
 *         Charset = "utf8",
 *         Collation = "utf8_general_ci",
 *         DatabaseName = "db1",
 *         ResourceGroupName = "TestGroup",
 *         ServerName = "testserver",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformariadb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformariadb.NewDatabase(ctx, "database", &dbformariadb.DatabaseArgs{
 * 			Charset:           pulumi.String("utf8"),
 * 			Collation:         pulumi.String("utf8_general_ci"),
 * 			DatabaseName:      pulumi.String("db1"),
 * 			ResourceGroupName: pulumi.String("TestGroup"),
 * 			ServerName:        pulumi.String("testserver"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformariadb.Database;
 * import com.pulumi.azurenative.dbformariadb.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .charset("utf8")
 *             .collation("utf8_general_ci")
 *             .databaseName("db1")
 *             .resourceGroupName("TestGroup")
 *             .serverName("testserver")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbformariadb:Database db1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMariaDB/servers/{serverName}/databases/{databaseName}
 * ```
 * @property charset The charset of the database.
 * @property collation The collation of the database.
 * @property databaseName The name of the database.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 */
public data class DatabaseArgs(
    public val charset: Output<String>? = null,
    public val collation: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformariadb.DatabaseArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformariadb.DatabaseArgs =
        com.pulumi.azurenative.dbformariadb.DatabaseArgs.builder()
            .charset(charset?.applyValue({ args0 -> args0 }))
            .collation(collation?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseArgs].
 */
@PulumiTagMarker
public class DatabaseArgsBuilder internal constructor() {
    private var charset: Output<String>? = null

    private var collation: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value The charset of the database.
     */
    @JvmName("uegeqydvetsqilpe")
    public suspend fun charset(`value`: Output<String>) {
        this.charset = value
    }

    /**
     * @param value The collation of the database.
     */
    @JvmName("rgbllcykpntodnnk")
    public suspend fun collation(`value`: Output<String>) {
        this.collation = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("dqsfiqgosnrlgsrc")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ryqfqgapxakxhnsr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("pjkmqrhdluiessdl")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The charset of the database.
     */
    @JvmName("ihtjqbpitduuhtlm")
    public suspend fun charset(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.charset = mapped
    }

    /**
     * @param value The collation of the database.
     */
    @JvmName("dsxvpqyarjuaygxu")
    public suspend fun collation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collation = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("kfovtyijbisogdvn")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qgmleslenaaiglrk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("txicxmtiyafncuhx")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): DatabaseArgs = DatabaseArgs(
        charset = charset,
        collation = collation,
        databaseName = databaseName,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
    )
}
