@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin

import com.pulumi.azurenative.dbformariadb.DbformariadbFunctions.getConfigurationPlain
import com.pulumi.azurenative.dbformariadb.DbformariadbFunctions.getDatabasePlain
import com.pulumi.azurenative.dbformariadb.DbformariadbFunctions.getFirewallRulePlain
import com.pulumi.azurenative.dbformariadb.DbformariadbFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.dbformariadb.DbformariadbFunctions.getServerPlain
import com.pulumi.azurenative.dbformariadb.DbformariadbFunctions.getVirtualNetworkRulePlain
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.GetConfigurationPlainArgs
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.GetConfigurationPlainArgsBuilder
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.GetDatabasePlainArgs
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.GetDatabasePlainArgsBuilder
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.GetFirewallRulePlainArgs
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.GetFirewallRulePlainArgsBuilder
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.GetServerPlainArgs
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.GetServerPlainArgsBuilder
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.GetVirtualNetworkRulePlainArgs
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.GetVirtualNetworkRulePlainArgsBuilder
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.GetConfigurationResult
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.GetDatabaseResult
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.GetFirewallRuleResult
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.GetServerResult
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.GetVirtualNetworkRuleResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.GetConfigurationResult.Companion.toKotlin as getConfigurationResultToKotlin
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.GetDatabaseResult.Companion.toKotlin as getDatabaseResultToKotlin
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.GetFirewallRuleResult.Companion.toKotlin as getFirewallRuleResultToKotlin
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.GetServerResult.Companion.toKotlin as getServerResultToKotlin
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.GetVirtualNetworkRuleResult.Companion.toKotlin as getVirtualNetworkRuleResultToKotlin

public object DbformariadbFunctions {
    /**
     * Gets information about a configuration of server.
     * Azure REST API version: 2018-06-01.
     * Other available API versions: 2018-06-01-preview.
     * @param argument null
     * @return Represents a Configuration.
     */
    public suspend fun getConfiguration(argument: GetConfigurationPlainArgs): GetConfigurationResult =
        getConfigurationResultToKotlin(getConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getConfiguration].
     * @param configurationName The name of the server configuration.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents a Configuration.
     */
    public suspend fun getConfiguration(
        configurationName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetConfigurationResult {
        val argument = GetConfigurationPlainArgs(
            configurationName = configurationName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getConfigurationResultToKotlin(getConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbformariadb&#46;kotlin&#46;inputs&#46;GetConfigurationPlainArgs].
     * @return Represents a Configuration.
     */
    public suspend fun getConfiguration(argument: suspend GetConfigurationPlainArgsBuilder.() -> Unit): GetConfigurationResult {
        val builder = GetConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationResultToKotlin(getConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a database.
     * Azure REST API version: 2018-06-01.
     * Other available API versions: 2018-06-01-preview.
     * @param argument null
     * @return Represents a Database.
     */
    public suspend fun getDatabase(argument: GetDatabasePlainArgs): GetDatabaseResult =
        getDatabaseResultToKotlin(getDatabasePlain(argument.toJava()).await())

    /**
     * @see [getDatabase].
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents a Database.
     */
    public suspend fun getDatabase(
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetDatabaseResult {
        val argument = GetDatabasePlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getDatabaseResultToKotlin(getDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbformariadb&#46;kotlin&#46;inputs&#46;GetDatabasePlainArgs].
     * @return Represents a Database.
     */
    public suspend fun getDatabase(argument: suspend GetDatabasePlainArgsBuilder.() -> Unit): GetDatabaseResult {
        val builder = GetDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseResultToKotlin(getDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a server firewall rule.
     * Azure REST API version: 2018-06-01.
     * Other available API versions: 2018-06-01-preview.
     * @param argument null
     * @return Represents a server firewall rule.
     */
    public suspend fun getFirewallRule(argument: GetFirewallRulePlainArgs): GetFirewallRuleResult =
        getFirewallRuleResultToKotlin(getFirewallRulePlain(argument.toJava()).await())

    /**
     * @see [getFirewallRule].
     * @param firewallRuleName The name of the server firewall rule.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents a server firewall rule.
     */
    public suspend fun getFirewallRule(
        firewallRuleName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetFirewallRuleResult {
        val argument = GetFirewallRulePlainArgs(
            firewallRuleName = firewallRuleName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getFirewallRuleResultToKotlin(getFirewallRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewallRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbformariadb&#46;kotlin&#46;inputs&#46;GetFirewallRulePlainArgs].
     * @return Represents a server firewall rule.
     */
    public suspend fun getFirewallRule(argument: suspend GetFirewallRulePlainArgsBuilder.() -> Unit): GetFirewallRuleResult {
        val builder = GetFirewallRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallRuleResultToKotlin(getFirewallRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private endpoint connection.
     * Azure REST API version: 2018-06-01.
     * Other available API versions: 2018-06-01-privatepreview.
     * @param argument null
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbformariadb&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a server.
     * Azure REST API version: 2018-06-01.
     * Other available API versions: 2018-06-01-preview.
     * @param argument null
     * @return Represents a server.
     */
    public suspend fun getServer(argument: GetServerPlainArgs): GetServerResult =
        getServerResultToKotlin(getServerPlain(argument.toJava()).await())

    /**
     * @see [getServer].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents a server.
     */
    public suspend fun getServer(resourceGroupName: String, serverName: String): GetServerResult {
        val argument = GetServerPlainArgs(
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getServerResultToKotlin(getServerPlain(argument.toJava()).await())
    }

    /**
     * @see [getServer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbformariadb&#46;kotlin&#46;inputs&#46;GetServerPlainArgs].
     * @return Represents a server.
     */
    public suspend fun getServer(argument: suspend GetServerPlainArgsBuilder.() -> Unit): GetServerResult {
        val builder = GetServerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerResultToKotlin(getServerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a virtual network rule.
     * Azure REST API version: 2018-06-01.
     * Other available API versions: 2018-06-01-preview.
     * @param argument null
     * @return A virtual network rule.
     */
    public suspend fun getVirtualNetworkRule(argument: GetVirtualNetworkRulePlainArgs): GetVirtualNetworkRuleResult =
        getVirtualNetworkRuleResultToKotlin(getVirtualNetworkRulePlain(argument.toJava()).await())

    /**
     * @see [getVirtualNetworkRule].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @param virtualNetworkRuleName The name of the virtual network rule.
     * @return A virtual network rule.
     */
    public suspend fun getVirtualNetworkRule(
        resourceGroupName: String,
        serverName: String,
        virtualNetworkRuleName: String,
    ): GetVirtualNetworkRuleResult {
        val argument = GetVirtualNetworkRulePlainArgs(
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            virtualNetworkRuleName = virtualNetworkRuleName,
        )
        return getVirtualNetworkRuleResultToKotlin(getVirtualNetworkRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualNetworkRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbformariadb&#46;kotlin&#46;inputs&#46;GetVirtualNetworkRulePlainArgs].
     * @return A virtual network rule.
     */
    public suspend fun getVirtualNetworkRule(argument: suspend GetVirtualNetworkRulePlainArgsBuilder.() -> Unit): GetVirtualNetworkRuleResult {
        val builder = GetVirtualNetworkRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualNetworkRuleResultToKotlin(getVirtualNetworkRulePlain(builtArgument.toJava()).await())
    }
}
