@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
 */
public enum class PublicNetworkAccessEnum(
    public val javaValue: com.pulumi.azurenative.dbformariadb.enums.PublicNetworkAccessEnum,
) : ConvertibleToJava<com.pulumi.azurenative.dbformariadb.enums.PublicNetworkAccessEnum> {
    Enabled(com.pulumi.azurenative.dbformariadb.enums.PublicNetworkAccessEnum.Enabled),
    Disabled(com.pulumi.azurenative.dbformariadb.enums.PublicNetworkAccessEnum.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.dbformariadb.enums.PublicNetworkAccessEnum =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbformariadb.enums.PublicNetworkAccessEnum): PublicNetworkAccessEnum =
            PublicNetworkAccessEnum.values().first { it.javaValue == javaType }
    }
}
