@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.inputs

import com.pulumi.azurenative.dbformariadb.inputs.SkuArgs.builder
import com.pulumi.azurenative.dbformariadb.kotlin.enums.SkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Billing information related properties of a server.
 * @property capacity The scale up/out capacity, representing server's compute units.
 * @property family The family of hardware.
 * @property name The name of the sku, typically, tier + family + cores, e.g. B_Gen4_1, GP_Gen5_8.
 * @property size The size code, to be interpreted by resource as appropriate.
 * @property tier The tier of the particular SKU, e.g. Basic.
 */
public data class SkuArgs(
    public val capacity: Output<Int>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>,
    public val size: Output<String>? = null,
    public val tier: Output<Either<String, SkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformariadb.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformariadb.inputs.SkuArgs =
        com.pulumi.azurenative.dbformariadb.inputs.SkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var size: Output<String>? = null

    private var tier: Output<Either<String, SkuTier>>? = null

    /**
     * @param value The scale up/out capacity, representing server's compute units.
     */
    @JvmName("iejitsarmimwamhh")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The family of hardware.
     */
    @JvmName("ucqvtdwrvcyatqjl")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The name of the sku, typically, tier + family + cores, e.g. B_Gen4_1, GP_Gen5_8.
     */
    @JvmName("btajjydwrrmqtryk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The size code, to be interpreted by resource as appropriate.
     */
    @JvmName("rkjpaxgyovdexnmu")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value The tier of the particular SKU, e.g. Basic.
     */
    @JvmName("wijaospospdmrcfa")
    public suspend fun tier(`value`: Output<Either<String, SkuTier>>) {
        this.tier = value
    }

    /**
     * @param value The scale up/out capacity, representing server's compute units.
     */
    @JvmName("ttujjbvekmrlkbwk")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The family of hardware.
     */
    @JvmName("dbkgalfclevumpcs")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the sku, typically, tier + family + cores, e.g. B_Gen4_1, GP_Gen5_8.
     */
    @JvmName("galblapqbuptpeky")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The size code, to be interpreted by resource as appropriate.
     */
    @JvmName("yetdyvsxysqqenjp")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The tier of the particular SKU, e.g. Basic.
     */
    @JvmName("pjpytpbddxkuepvn")
    public suspend fun tier(`value`: Either<String, SkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The tier of the particular SKU, e.g. Basic.
     */
    @JvmName("eyupoqoftodxipmp")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The tier of the particular SKU, e.g. Basic.
     */
    @JvmName("oxrkqyeinmgebonj")
    public fun tier(`value`: SkuTier) {
        val toBeMapped = Either.ofRight<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity,
        family = family,
        name = name ?: throw PulumiNullFieldException("name"),
        size = size,
        tier = tier,
    )
}
