@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a Database.
 * @property charset The charset of the database.
 * @property collation The collation of the database.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDatabaseResult(
    public val charset: String? = null,
    public val collation: String? = null,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbformariadb.outputs.GetDatabaseResult): GetDatabaseResult = GetDatabaseResult(
            charset = javaType.charset().map({ args0 -> args0 }).orElse(null),
            collation = javaType.collation().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
