@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a server firewall rule.
 * @property endIpAddress The end IP address of the server firewall rule. Must be IPv4 format.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property startIpAddress The start IP address of the server firewall rule. Must be IPv4 format.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetFirewallRuleResult(
    public val endIpAddress: String,
    public val id: String,
    public val name: String,
    public val startIpAddress: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbformariadb.outputs.GetFirewallRuleResult): GetFirewallRuleResult = GetFirewallRuleResult(
            endIpAddress = javaType.endIpAddress(),
            id = javaType.id(),
            name = javaType.name(),
            startIpAddress = javaType.startIpAddress(),
            type = javaType.type(),
        )
    }
}
