@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Storage Profile properties of a server
 * @property backupRetentionDays Backup retention days for the server.
 * @property geoRedundantBackup Enable Geo-redundant or not for server backup.
 * @property storageAutogrow Enable Storage Auto Grow.
 * @property storageMB Max storage allowed for a server.
 */
public data class StorageProfileResponse(
    public val backupRetentionDays: Int? = null,
    public val geoRedundantBackup: String? = null,
    public val storageAutogrow: String? = null,
    public val storageMB: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbformariadb.outputs.StorageProfileResponse): StorageProfileResponse = StorageProfileResponse(
            backupRetentionDays = javaType.backupRetentionDays().map({ args0 -> args0 }).orElse(null),
            geoRedundantBackup = javaType.geoRedundantBackup().map({ args0 -> args0 }).orElse(null),
            storageAutogrow = javaType.storageAutogrow().map({ args0 -> args0 }).orElse(null),
            storageMB = javaType.storageMB().map({ args0 -> args0 }).orElse(null),
        )
    }
}
