@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin

import com.pulumi.azurenative.dbformysql.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.dbformysql.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AzureADAdministrator].
 */
@PulumiTagMarker
public class AzureADAdministratorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AzureADAdministratorArgs = AzureADAdministratorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AzureADAdministratorArgsBuilder.() -> Unit) {
        val builder = AzureADAdministratorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AzureADAdministrator {
        val builtJavaResource =
            com.pulumi.azurenative.dbformysql.AzureADAdministrator(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AzureADAdministrator(builtJavaResource)
    }
}

/**
 * Represents a Administrator.
 * Azure REST API version: 2022-01-01.
 * Other available API versions: 2023-06-01-preview, 2023-06-30.
 * ## Example Usage
 * ### Create an azure ad administrator
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureADAdministrator = new AzureNative.DBforMySQL.AzureADAdministrator("azureADAdministrator", new()
 *     {
 *         AdministratorName = "ActiveDirectory",
 *         AdministratorType = AzureNative.DBforMySQL.AdministratorType.ActiveDirectory,
 *         IdentityResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/test-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-umi",
 *         Login = "bob@contoso.com",
 *         ResourceGroupName = "testrg",
 *         ServerName = "mysqltestsvc4",
 *         Sid = "c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c",
 *         TenantId = "c12b7025-bfe2-46c1-b463-993b5e4cd467",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformysql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformysql.NewAzureADAdministrator(ctx, "azureADAdministrator", &dbformysql.AzureADAdministratorArgs{
 * 			AdministratorName:  pulumi.String("ActiveDirectory"),
 * 			AdministratorType:  pulumi.String(dbformysql.AdministratorTypeActiveDirectory),
 * 			IdentityResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/test-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-umi"),
 * 			Login:              pulumi.String("bob@contoso.com"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			ServerName:         pulumi.String("mysqltestsvc4"),
 * 			Sid:                pulumi.String("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c"),
 * 			TenantId:           pulumi.String("c12b7025-bfe2-46c1-b463-993b5e4cd467"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformysql.AzureADAdministrator;
 * import com.pulumi.azurenative.dbformysql.AzureADAdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureADAdministrator = new AzureADAdministrator("azureADAdministrator", AzureADAdministratorArgs.builder()
 *             .administratorName("ActiveDirectory")
 *             .administratorType("ActiveDirectory")
 *             .identityResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/test-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-umi")
 *             .login("bob@contoso.com")
 *             .resourceGroupName("testrg")
 *             .serverName("mysqltestsvc4")
 *             .sid("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c")
 *             .tenantId("c12b7025-bfe2-46c1-b463-993b5e4cd467")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbformysql:AzureADAdministrator ActiveDirectory /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/administrators/{administratorName}
 * ```
 */
public class AzureADAdministrator internal constructor(
    override val javaResource: com.pulumi.azurenative.dbformysql.AzureADAdministrator,
) : KotlinCustomResource(javaResource, AzureADAdministratorMapper) {
    /**
     * Type of the sever administrator.
     */
    public val administratorType: Output<String>?
        get() = javaResource.administratorType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource id of the identity used for AAD Authentication.
     */
    public val identityResourceId: Output<String>?
        get() = javaResource.identityResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Login name of the server administrator.
     */
    public val login: Output<String>?
        get() = javaResource.login().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * SID (object ID) of the server administrator.
     */
    public val sid: Output<String>?
        get() = javaResource.sid().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Tenant ID of the administrator.
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AzureADAdministratorMapper : ResourceMapper<AzureADAdministrator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dbformysql.AzureADAdministrator::class == javaResource::class

    override fun map(javaResource: Resource): AzureADAdministrator = AzureADAdministrator(
        javaResource
            as com.pulumi.azurenative.dbformysql.AzureADAdministrator,
    )
}

/**
 * @see [AzureADAdministrator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AzureADAdministrator].
 */
public suspend fun azureADAdministrator(
    name: String,
    block: suspend AzureADAdministratorResourceBuilder.() -> Unit,
): AzureADAdministrator {
    val builder = AzureADAdministratorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AzureADAdministrator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun azureADAdministrator(name: String): AzureADAdministrator {
    val builder = AzureADAdministratorResourceBuilder()
    builder.name(name)
    return builder.build()
}
