@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin

import com.pulumi.azurenative.dbformysql.ConfigurationArgs.builder
import com.pulumi.azurenative.dbformysql.kotlin.enums.ConfigurationSource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a Configuration.
 * Azure REST API version: 2022-01-01. Prior API version in Azure Native 1.x: 2017-12-01.
 * Other available API versions: 2017-12-01, 2020-07-01-privatepreview, 2023-06-01-preview, 2023-06-30.
 * ## Example Usage
 * ### ConfigurationCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configuration = new AzureNative.DBforMySQL.Configuration("configuration", new()
 *     {
 *         ConfigurationName = "event_scheduler",
 *         ResourceGroupName = "TestGroup",
 *         ServerName = "testserver",
 *         Source = AzureNative.DBforMySQL.ConfigurationSource.User_override,
 *         Value = "off",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformysql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformysql.NewConfiguration(ctx, "configuration", &dbformysql.ConfigurationArgs{
 * 			ConfigurationName: pulumi.String("event_scheduler"),
 * 			ResourceGroupName: pulumi.String("TestGroup"),
 * 			ServerName:        pulumi.String("testserver"),
 * 			Source:            pulumi.String(dbformysql.ConfigurationSource_User_Override),
 * 			Value:             pulumi.String("off"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformysql.Configuration;
 * import com.pulumi.azurenative.dbformysql.ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configuration = new Configuration("configuration", ConfigurationArgs.builder()
 *             .configurationName("event_scheduler")
 *             .resourceGroupName("TestGroup")
 *             .serverName("testserver")
 *             .source("user-override")
 *             .value("off")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbformysql:Configuration event_scheduler /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/configurations/{configurationName}
 * ```
 * @property configurationName The name of the server configuration.
 * @property currentValue Current value of the configuration.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 * @property source Source of the configuration.
 * @property value Value of the configuration.
 */
public data class ConfigurationArgs(
    public val configurationName: Output<String>? = null,
    public val currentValue: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val source: Output<Either<String, ConfigurationSource>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformysql.ConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformysql.ConfigurationArgs =
        com.pulumi.azurenative.dbformysql.ConfigurationArgs.builder()
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .currentValue(currentValue?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .source(
                source?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationArgs].
 */
@PulumiTagMarker
public class ConfigurationArgsBuilder internal constructor() {
    private var configurationName: Output<String>? = null

    private var currentValue: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var source: Output<Either<String, ConfigurationSource>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the server configuration.
     */
    @JvmName("nmypukipbtpogaid")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value Current value of the configuration.
     */
    @JvmName("ugurxcbpkmttdycj")
    public suspend fun currentValue(`value`: Output<String>) {
        this.currentValue = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("etpjpcembxtulkwm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ofmceaxcelcqguim")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Source of the configuration.
     */
    @JvmName("krrjvkrqpdavvkwu")
    public suspend fun source(`value`: Output<Either<String, ConfigurationSource>>) {
        this.source = value
    }

    /**
     * @param value Value of the configuration.
     */
    @JvmName("ppgnahusbtqydgcy")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the server configuration.
     */
    @JvmName("poabwxkhuxqoixcb")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value Current value of the configuration.
     */
    @JvmName("dccbnjwiajlukhrx")
    public suspend fun currentValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currentValue = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("blgwcqsclgpeigsy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("iufrswuqkwiabcku")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value Source of the configuration.
     */
    @JvmName("edkttymjgqlembpu")
    public suspend fun source(`value`: Either<String, ConfigurationSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Source of the configuration.
     */
    @JvmName("rxygkcjgvvrrpqsm")
    public fun source(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConfigurationSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Source of the configuration.
     */
    @JvmName("eqoatqsyguledhxp")
    public fun source(`value`: ConfigurationSource) {
        val toBeMapped = Either.ofRight<String, ConfigurationSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Value of the configuration.
     */
    @JvmName("hcntnscxeuuxonyn")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ConfigurationArgs = ConfigurationArgs(
        configurationName = configurationName,
        currentValue = currentValue,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        source = source,
        `value` = `value`,
    )
}
