@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin

import com.pulumi.azurenative.dbformysql.kotlin.outputs.BackupResponse
import com.pulumi.azurenative.dbformysql.kotlin.outputs.DataEncryptionResponse
import com.pulumi.azurenative.dbformysql.kotlin.outputs.HighAvailabilityResponse
import com.pulumi.azurenative.dbformysql.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.dbformysql.kotlin.outputs.MaintenanceWindowResponse
import com.pulumi.azurenative.dbformysql.kotlin.outputs.NetworkResponse
import com.pulumi.azurenative.dbformysql.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.dbformysql.kotlin.outputs.StorageResponse
import com.pulumi.azurenative.dbformysql.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.dbformysql.kotlin.outputs.BackupResponse.Companion.toKotlin as backupResponseToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.DataEncryptionResponse.Companion.toKotlin as dataEncryptionResponseToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.HighAvailabilityResponse.Companion.toKotlin as highAvailabilityResponseToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.MaintenanceWindowResponse.Companion.toKotlin as maintenanceWindowResponseToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.NetworkResponse.Companion.toKotlin as networkResponseToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.StorageResponse.Companion.toKotlin as storageResponseToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Server].
 */
@PulumiTagMarker
public class ServerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerArgs = ServerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerArgsBuilder.() -> Unit) {
        val builder = ServerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Server {
        val builtJavaResource = com.pulumi.azurenative.dbformysql.Server(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Server(builtJavaResource)
    }
}

/**
 * Represents a server.
 * Azure REST API version: 2022-01-01. Prior API version in Azure Native 1.x: 2017-12-01.
 * Other available API versions: 2017-12-01, 2018-06-01-privatepreview, 2020-07-01-preview, 2020-07-01-privatepreview, 2022-09-30-preview, 2023-06-01-preview, 2023-06-30, 2023-10-01-preview, 2023-12-01-preview, 2023-12-30, 2024-02-01-preview.
 * ## Example Usage
 * ### Create a new server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMySQL.Server("server", new()
 *     {
 *         AdministratorLogin = "cloudsa",
 *         AdministratorLoginPassword = "your_password",
 *         AvailabilityZone = "1",
 *         Backup = new AzureNative.DBforMySQL.Inputs.BackupArgs
 *         {
 *             BackupRetentionDays = 7,
 *             GeoRedundantBackup = AzureNative.DBforMySQL.EnableStatusEnum.Disabled,
 *         },
 *         CreateMode = AzureNative.DBforMySQL.CreateMode.Default,
 *         HighAvailability = new AzureNative.DBforMySQL.Inputs.HighAvailabilityArgs
 *         {
 *             Mode = AzureNative.DBforMySQL.HighAvailabilityMode.ZoneRedundant,
 *             StandbyAvailabilityZone = "3",
 *         },
 *         Location = "southeastasia",
 *         ResourceGroupName = "testrg",
 *         ServerName = "mysqltestserver",
 *         Sku = new AzureNative.DBforMySQL.Inputs.SkuArgs
 *         {
 *             Name = "Standard_D2ds_v4",
 *             Tier = AzureNative.DBforMySQL.SkuTier.GeneralPurpose,
 *         },
 *         Storage = new AzureNative.DBforMySQL.Inputs.StorageArgs
 *         {
 *             AutoGrow = AzureNative.DBforMySQL.EnableStatusEnum.Disabled,
 *             Iops = 600,
 *             StorageSizeGB = 100,
 *         },
 *         Tags =
 *         {
 *             { "num", "1" },
 *         },
 *         Version = AzureNative.DBforMySQL.ServerVersion.ServerVersion_5_7,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformysql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformysql.NewServer(ctx, "server", &dbformysql.ServerArgs{
 * 			AdministratorLogin:         pulumi.String("cloudsa"),
 * 			AdministratorLoginPassword: pulumi.String("your_password"),
 * 			AvailabilityZone:           pulumi.String("1"),
 * 			Backup: &dbformysql.BackupArgs{
 * 				BackupRetentionDays: pulumi.Int(7),
 * 				GeoRedundantBackup:  pulumi.String(dbformysql.EnableStatusEnumDisabled),
 * 			},
 * 			CreateMode: pulumi.String(dbformysql.CreateModeDefault),
 * 			HighAvailability: &dbformysql.HighAvailabilityArgs{
 * 				Mode:                    pulumi.String(dbformysql.HighAvailabilityModeZoneRedundant),
 * 				StandbyAvailabilityZone: pulumi.String("3"),
 * 			},
 * 			Location:          pulumi.String("southeastasia"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerName:        pulumi.String("mysqltestserver"),
 * 			Sku: &dbformysql.SkuArgs{
 * 				Name: pulumi.String("Standard_D2ds_v4"),
 * 				Tier: pulumi.String(dbformysql.SkuTierGeneralPurpose),
 * 			},
 * 			Storage: &dbformysql.StorageArgs{
 * 				AutoGrow:      pulumi.String(dbformysql.EnableStatusEnumDisabled),
 * 				Iops:          pulumi.Int(600),
 * 				StorageSizeGB: pulumi.Int(100),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"num": pulumi.String("1"),
 * 			},
 * 			Version: pulumi.String(dbformysql.ServerVersion_5_7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformysql.Server;
 * import com.pulumi.azurenative.dbformysql.ServerArgs;
 * import com.pulumi.azurenative.dbformysql.inputs.BackupArgs;
 * import com.pulumi.azurenative.dbformysql.inputs.HighAvailabilityArgs;
 * import com.pulumi.azurenative.dbformysql.inputs.SkuArgs;
 * import com.pulumi.azurenative.dbformysql.inputs.StorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .administratorLogin("cloudsa")
 *             .administratorLoginPassword("your_password")
 *             .availabilityZone("1")
 *             .backup(BackupArgs.builder()
 *                 .backupRetentionDays(7)
 *                 .geoRedundantBackup("Disabled")
 *                 .build())
 *             .createMode("Default")
 *             .highAvailability(HighAvailabilityArgs.builder()
 *                 .mode("ZoneRedundant")
 *                 .standbyAvailabilityZone("3")
 *                 .build())
 *             .location("southeastasia")
 *             .resourceGroupName("testrg")
 *             .serverName("mysqltestserver")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_D2ds_v4")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .storage(StorageArgs.builder()
 *                 .autoGrow("Disabled")
 *                 .iops(600)
 *                 .storageSizeGB(100)
 *                 .build())
 *             .tags(Map.of("num", "1"))
 *             .version("5.7")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a replica server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMySQL.Server("server", new()
 *     {
 *         CreateMode = AzureNative.DBforMySQL.CreateMode.Replica,
 *         Location = "SoutheastAsia",
 *         ResourceGroupName = "testgr",
 *         ServerName = "replica-server",
 *         SourceServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testgr/providers/Microsoft.DBforMySQL/flexibleServers/source-server",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformysql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformysql.NewServer(ctx, "server", &dbformysql.ServerArgs{
 * 			CreateMode:             pulumi.String(dbformysql.CreateModeReplica),
 * 			Location:               pulumi.String("SoutheastAsia"),
 * 			ResourceGroupName:      pulumi.String("testgr"),
 * 			ServerName:             pulumi.String("replica-server"),
 * 			SourceServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testgr/providers/Microsoft.DBforMySQL/flexibleServers/source-server"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformysql.Server;
 * import com.pulumi.azurenative.dbformysql.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .createMode("Replica")
 *             .location("SoutheastAsia")
 *             .resourceGroupName("testgr")
 *             .serverName("replica-server")
 *             .sourceServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testgr/providers/Microsoft.DBforMySQL/flexibleServers/source-server")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a server as a point in time restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMySQL.Server("server", new()
 *     {
 *         CreateMode = AzureNative.DBforMySQL.CreateMode.PointInTimeRestore,
 *         Location = "SoutheastAsia",
 *         ResourceGroupName = "TargetResourceGroup",
 *         RestorePointInTime = "2021-06-24T00:00:37.467Z",
 *         ServerName = "targetserver",
 *         Sku = new AzureNative.DBforMySQL.Inputs.SkuArgs
 *         {
 *             Name = "Standard_D14_v2",
 *             Tier = AzureNative.DBforMySQL.SkuTier.GeneralPurpose,
 *         },
 *         SourceServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMySQL/flexibleServers/sourceserver",
 *         Tags =
 *         {
 *             { "num", "1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformysql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformysql.NewServer(ctx, "server", &dbformysql.ServerArgs{
 * 			CreateMode:         pulumi.String(dbformysql.CreateModePointInTimeRestore),
 * 			Location:           pulumi.String("SoutheastAsia"),
 * 			ResourceGroupName:  pulumi.String("TargetResourceGroup"),
 * 			RestorePointInTime: pulumi.String("2021-06-24T00:00:37.467Z"),
 * 			ServerName:         pulumi.String("targetserver"),
 * 			Sku: &dbformysql.SkuArgs{
 * 				Name: pulumi.String("Standard_D14_v2"),
 * 				Tier: pulumi.String(dbformysql.SkuTierGeneralPurpose),
 * 			},
 * 			SourceServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMySQL/flexibleServers/sourceserver"),
 * 			Tags: pulumi.StringMap{
 * 				"num": pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformysql.Server;
 * import com.pulumi.azurenative.dbformysql.ServerArgs;
 * import com.pulumi.azurenative.dbformysql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .createMode("PointInTimeRestore")
 *             .location("SoutheastAsia")
 *             .resourceGroupName("TargetResourceGroup")
 *             .restorePointInTime("2021-06-24T00:00:37.467Z")
 *             .serverName("targetserver")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_D14_v2")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .sourceServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMySQL/flexibleServers/sourceserver")
 *             .tags(Map.of("num", "1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbformysql:Server mysqltestserver /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}
 * ```
 */
public class Server internal constructor(
    override val javaResource: com.pulumi.azurenative.dbformysql.Server,
) : KotlinCustomResource(javaResource, ServerMapper) {
    /**
     * The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
     */
    public val administratorLogin: Output<String>?
        get() = javaResource.administratorLogin().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * availability Zone information of the server.
     */
    public val availabilityZone: Output<String>?
        get() = javaResource.availabilityZone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Backup related properties of a server.
     */
    public val backup: Output<BackupResponse>?
        get() = javaResource.backup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    backupResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Data Encryption for CMK.
     */
    public val dataEncryption: Output<DataEncryptionResponse>?
        get() = javaResource.dataEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataEncryptionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The fully qualified domain name of a server.
     */
    public val fullyQualifiedDomainName: Output<String>
        get() = javaResource.fullyQualifiedDomainName().applyValue({ args0 -> args0 })

    /**
     * High availability related properties of a server.
     */
    public val highAvailability: Output<HighAvailabilityResponse>?
        get() = javaResource.highAvailability().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> highAvailabilityResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The cmk identity for the server.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Maintenance window of a server.
     */
    public val maintenanceWindow: Output<MaintenanceWindowResponse>?
        get() = javaResource.maintenanceWindow().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> maintenanceWindowResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network related properties of a server.
     */
    public val network: Output<NetworkResponse>?
        get() = javaResource.network().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    networkResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The maximum number of replicas that a primary server can have.
     */
    public val replicaCapacity: Output<Int>
        get() = javaResource.replicaCapacity().applyValue({ args0 -> args0 })

    /**
     * The replication role.
     */
    public val replicationRole: Output<String>?
        get() = javaResource.replicationRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SKU (pricing tier) of the server.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The source MySQL server id.
     */
    public val sourceServerResourceId: Output<String>?
        get() = javaResource.sourceServerResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of a server.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Storage related properties of a server.
     */
    public val storage: Output<StorageResponse>?
        get() = javaResource.storage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    storageResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Server version.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ServerMapper : ResourceMapper<Server> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dbformysql.Server::class == javaResource::class

    override fun map(javaResource: Resource): Server = Server(
        javaResource as
            com.pulumi.azurenative.dbformysql.Server,
    )
}

/**
 * @see [Server].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Server].
 */
public suspend fun server(name: String, block: suspend ServerResourceBuilder.() -> Unit): Server {
    val builder = ServerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Server].
 * @param name The _unique_ name of the resulting resource.
 */
public fun server(name: String): Server {
    val builder = ServerResourceBuilder()
    builder.name(name)
    return builder.build()
}
