@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.inputs

import com.pulumi.azurenative.dbformysql.inputs.DataEncryptionArgs.builder
import com.pulumi.azurenative.dbformysql.kotlin.enums.DataEncryptionType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The date encryption for cmk.
 * @property geoBackupKeyURI Geo backup key uri as key vault can't cross region, need cmk in same region as geo backup
 * @property geoBackupUserAssignedIdentityId Geo backup user identity resource id as identity can't cross region, need identity in same region as geo backup
 * @property primaryKeyURI Primary key uri
 * @property primaryUserAssignedIdentityId Primary user identity resource id
 * @property type The key type, AzureKeyVault for enable cmk, SystemManaged for disable cmk.
 */
public data class DataEncryptionArgs(
    public val geoBackupKeyURI: Output<String>? = null,
    public val geoBackupUserAssignedIdentityId: Output<String>? = null,
    public val primaryKeyURI: Output<String>? = null,
    public val primaryUserAssignedIdentityId: Output<String>? = null,
    public val type: Output<DataEncryptionType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformysql.inputs.DataEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformysql.inputs.DataEncryptionArgs =
        com.pulumi.azurenative.dbformysql.inputs.DataEncryptionArgs.builder()
            .geoBackupKeyURI(geoBackupKeyURI?.applyValue({ args0 -> args0 }))
            .geoBackupUserAssignedIdentityId(geoBackupUserAssignedIdentityId?.applyValue({ args0 -> args0 }))
            .primaryKeyURI(primaryKeyURI?.applyValue({ args0 -> args0 }))
            .primaryUserAssignedIdentityId(primaryUserAssignedIdentityId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataEncryptionArgs].
 */
@PulumiTagMarker
public class DataEncryptionArgsBuilder internal constructor() {
    private var geoBackupKeyURI: Output<String>? = null

    private var geoBackupUserAssignedIdentityId: Output<String>? = null

    private var primaryKeyURI: Output<String>? = null

    private var primaryUserAssignedIdentityId: Output<String>? = null

    private var type: Output<DataEncryptionType>? = null

    /**
     * @param value Geo backup key uri as key vault can't cross region, need cmk in same region as geo backup
     */
    @JvmName("bvbpxorwaaydutbg")
    public suspend fun geoBackupKeyURI(`value`: Output<String>) {
        this.geoBackupKeyURI = value
    }

    /**
     * @param value Geo backup user identity resource id as identity can't cross region, need identity in same region as geo backup
     */
    @JvmName("jnhvlabsgcwvgqju")
    public suspend fun geoBackupUserAssignedIdentityId(`value`: Output<String>) {
        this.geoBackupUserAssignedIdentityId = value
    }

    /**
     * @param value Primary key uri
     */
    @JvmName("ovumlypedihsehyd")
    public suspend fun primaryKeyURI(`value`: Output<String>) {
        this.primaryKeyURI = value
    }

    /**
     * @param value Primary user identity resource id
     */
    @JvmName("itdhjaerbfgsytay")
    public suspend fun primaryUserAssignedIdentityId(`value`: Output<String>) {
        this.primaryUserAssignedIdentityId = value
    }

    /**
     * @param value The key type, AzureKeyVault for enable cmk, SystemManaged for disable cmk.
     */
    @JvmName("tchirvjpgpjntjyn")
    public suspend fun type(`value`: Output<DataEncryptionType>) {
        this.type = value
    }

    /**
     * @param value Geo backup key uri as key vault can't cross region, need cmk in same region as geo backup
     */
    @JvmName("feaaapmairbkiqdp")
    public suspend fun geoBackupKeyURI(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoBackupKeyURI = mapped
    }

    /**
     * @param value Geo backup user identity resource id as identity can't cross region, need identity in same region as geo backup
     */
    @JvmName("nwxwscvnggpcekyr")
    public suspend fun geoBackupUserAssignedIdentityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoBackupUserAssignedIdentityId = mapped
    }

    /**
     * @param value Primary key uri
     */
    @JvmName("ngdqpnvlxncoxqdi")
    public suspend fun primaryKeyURI(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryKeyURI = mapped
    }

    /**
     * @param value Primary user identity resource id
     */
    @JvmName("xrfuevibyesekbqq")
    public suspend fun primaryUserAssignedIdentityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryUserAssignedIdentityId = mapped
    }

    /**
     * @param value The key type, AzureKeyVault for enable cmk, SystemManaged for disable cmk.
     */
    @JvmName("dqmnpxaqtoxnftjl")
    public suspend fun type(`value`: DataEncryptionType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DataEncryptionArgs = DataEncryptionArgs(
        geoBackupKeyURI = geoBackupKeyURI,
        geoBackupUserAssignedIdentityId = geoBackupUserAssignedIdentityId,
        primaryKeyURI = primaryKeyURI,
        primaryUserAssignedIdentityId = primaryUserAssignedIdentityId,
        type = type,
    )
}
