@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.inputs

import com.pulumi.azurenative.dbformysql.inputs.GetAzureADAdministratorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property administratorName The name of the Azure AD Administrator.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 */
public data class GetAzureADAdministratorPlainArgs(
    public val administratorName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.dbformysql.inputs.GetAzureADAdministratorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformysql.inputs.GetAzureADAdministratorPlainArgs =
        com.pulumi.azurenative.dbformysql.inputs.GetAzureADAdministratorPlainArgs.builder()
            .administratorName(administratorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAzureADAdministratorPlainArgs].
 */
@PulumiTagMarker
public class GetAzureADAdministratorPlainArgsBuilder internal constructor() {
    private var administratorName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the Azure AD Administrator.
     */
    @JvmName("awtvccjcksydjnaq")
    public suspend fun administratorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.administratorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("txvjaaynpcwcvqhw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("pupythlmwrhubrfa")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetAzureADAdministratorPlainArgs = GetAzureADAdministratorPlainArgs(
        administratorName = administratorName ?: throw PulumiNullFieldException("administratorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
