@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.inputs

import com.pulumi.azurenative.dbformysql.inputs.IdentityArgs.builder
import com.pulumi.azurenative.dbformysql.kotlin.enums.ManagedServiceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties to configure Identity for Bring your Own Keys
 * @property type Type of managed service identity.
 * @property userAssignedIdentities Metadata of user assigned identity.
 */
public data class IdentityArgs(
    public val type: Output<ManagedServiceIdentityType>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformysql.inputs.IdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformysql.inputs.IdentityArgs =
        com.pulumi.azurenative.dbformysql.inputs.IdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityArgs].
 */
@PulumiTagMarker
public class IdentityArgsBuilder internal constructor() {
    private var type: Output<ManagedServiceIdentityType>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value Type of managed service identity.
     */
    @JvmName("kvneulknsrmetked")
    public suspend fun type(`value`: Output<ManagedServiceIdentityType>) {
        this.type = value
    }

    /**
     * @param value Metadata of user assigned identity.
     */
    @JvmName("wtlrrbgaoaytpfjn")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("eqpiiihirlnyaqlk")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values Metadata of user assigned identity.
     */
    @JvmName("pmiklqbsmskfvtrx")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value Type of managed service identity.
     */
    @JvmName("mgeehpksnsnowxmc")
    public suspend fun type(`value`: ManagedServiceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Metadata of user assigned identity.
     */
    @JvmName("mkdktjhvkbgnrpju")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values Metadata of user assigned identity.
     */
    @JvmName("safocugpkaopoacj")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): IdentityArgs = IdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
