@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Storage Profile properties of a server
 * @property backupRetentionDays Backup retention days for the server.
 * @property earliestRestoreDate Earliest restore point creation time (ISO8601 format)
 * @property geoRedundantBackup Whether or not geo redundant backup is enabled.
 */
public data class BackupResponse(
    public val backupRetentionDays: Int? = null,
    public val earliestRestoreDate: String,
    public val geoRedundantBackup: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbformysql.outputs.BackupResponse): BackupResponse = BackupResponse(
            backupRetentionDays = javaType.backupRetentionDays().map({ args0 -> args0 }).orElse(null),
            earliestRestoreDate = javaType.earliestRestoreDate(),
            geoRedundantBackup = javaType.geoRedundantBackup().map({ args0 -> args0 }).orElse(null),
        )
    }
}
