@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The date encryption for cmk.
 * @property geoBackupKeyURI Geo backup key uri as key vault can't cross region, need cmk in same region as geo backup
 * @property geoBackupUserAssignedIdentityId Geo backup user identity resource id as identity can't cross region, need identity in same region as geo backup
 * @property primaryKeyURI Primary key uri
 * @property primaryUserAssignedIdentityId Primary user identity resource id
 * @property type The key type, AzureKeyVault for enable cmk, SystemManaged for disable cmk.
 */
public data class DataEncryptionResponse(
    public val geoBackupKeyURI: String? = null,
    public val geoBackupUserAssignedIdentityId: String? = null,
    public val primaryKeyURI: String? = null,
    public val primaryUserAssignedIdentityId: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbformysql.outputs.DataEncryptionResponse): DataEncryptionResponse = DataEncryptionResponse(
            geoBackupKeyURI = javaType.geoBackupKeyURI().map({ args0 -> args0 }).orElse(null),
            geoBackupUserAssignedIdentityId = javaType.geoBackupUserAssignedIdentityId().map({ args0 ->
                args0
            }).orElse(null),
            primaryKeyURI = javaType.primaryKeyURI().map({ args0 -> args0 }).orElse(null),
            primaryUserAssignedIdentityId = javaType.primaryUserAssignedIdentityId().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
