@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents a server.
 * @property administratorLogin The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
 * @property availabilityZone availability Zone information of the server.
 * @property backup Backup related properties of a server.
 * @property dataEncryption The Data Encryption for CMK.
 * @property fullyQualifiedDomainName The fully qualified domain name of a server.
 * @property highAvailability High availability related properties of a server.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The cmk identity for the server.
 * @property location The geo-location where the resource lives
 * @property maintenanceWindow Maintenance window of a server.
 * @property name The name of the resource
 * @property network Network related properties of a server.
 * @property replicaCapacity The maximum number of replicas that a primary server can have.
 * @property replicationRole The replication role.
 * @property sku The SKU (pricing tier) of the server.
 * @property sourceServerResourceId The source MySQL server id.
 * @property state The state of a server.
 * @property storage Storage related properties of a server.
 * @property systemData The system metadata relating to this resource.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version Server version.
 */
public data class GetServerResult(
    public val administratorLogin: String? = null,
    public val availabilityZone: String? = null,
    public val backup: BackupResponse? = null,
    public val dataEncryption: DataEncryptionResponse? = null,
    public val fullyQualifiedDomainName: String,
    public val highAvailability: HighAvailabilityResponse? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String,
    public val maintenanceWindow: MaintenanceWindowResponse? = null,
    public val name: String,
    public val network: NetworkResponse? = null,
    public val replicaCapacity: Int,
    public val replicationRole: String? = null,
    public val sku: SkuResponse? = null,
    public val sourceServerResourceId: String? = null,
    public val state: String,
    public val storage: StorageResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbformysql.outputs.GetServerResult): GetServerResult = GetServerResult(
            administratorLogin = javaType.administratorLogin().map({ args0 -> args0 }).orElse(null),
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            backup = javaType.backup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbformysql.kotlin.outputs.BackupResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataEncryption = javaType.dataEncryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbformysql.kotlin.outputs.DataEncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fullyQualifiedDomainName = javaType.fullyQualifiedDomainName(),
            highAvailability = javaType.highAvailability().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbformysql.kotlin.outputs.HighAvailabilityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbformysql.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            maintenanceWindow = javaType.maintenanceWindow().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbformysql.kotlin.outputs.MaintenanceWindowResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            network = javaType.network().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbformysql.kotlin.outputs.NetworkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            replicaCapacity = javaType.replicaCapacity(),
            replicationRole = javaType.replicationRole().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbformysql.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceServerResourceId = javaType.sourceServerResourceId().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
            storage = javaType.storage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbformysql.kotlin.outputs.StorageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dbformysql.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
