@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Billing information related properties of a server.
 * @property name The name of the sku, e.g. Standard_D32s_v3.
 * @property tier The tier of the particular SKU, e.g. GeneralPurpose.
 */
public data class SkuResponse(
    public val name: String,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbformysql.outputs.SkuResponse): SkuResponse = SkuResponse(
            name = javaType.name(),
            tier = javaType.tier(),
        )
    }
}
