@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Storage Profile properties of a server
 * @property autoGrow Enable Storage Auto Grow or not.
 * @property autoIoScaling Enable IO Auto Scaling or not.
 * @property iops Storage IOPS for a server.
 * @property logOnDisk Enable Log On Disk or not.
 * @property storageSizeGB Max storage size allowed for a server.
 * @property storageSku The sku name of the server storage.
 */
public data class StorageResponse(
    public val autoGrow: String? = null,
    public val autoIoScaling: String? = null,
    public val iops: Int? = null,
    public val logOnDisk: String? = null,
    public val storageSizeGB: Int? = null,
    public val storageSku: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbformysql.outputs.StorageResponse): StorageResponse = StorageResponse(
            autoGrow = javaType.autoGrow().map({ args0 -> args0 }).orElse(null),
            autoIoScaling = javaType.autoIoScaling().map({ args0 -> args0 }).orElse(null),
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            logOnDisk = javaType.logOnDisk().map({ args0 -> args0 }).orElse(null),
            storageSizeGB = javaType.storageSizeGB().map({ args0 -> args0 }).orElse(null),
            storageSku = javaType.storageSku(),
        )
    }
}
