@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.MaintenanceWindowResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.ServerNameItemResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SimplePrivateEndpointConnectionResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.MaintenanceWindowResponse.Companion.toKotlin as maintenanceWindowResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.ServerNameItemResponse.Companion.toKotlin as serverNameItemResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SimplePrivateEndpointConnectionResponse.Companion.toKotlin as simplePrivateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.azurenative.dbforpostgresql.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Represents a cluster.
 * Azure REST API version: 2022-11-08.
 * Other available API versions: 2023-03-02-preview.
 * ## Example Usage
 * ### Create a new cluster as a point in time restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.DBforPostgreSQL.Cluster("cluster", new()
 *     {
 *         ClusterName = "testcluster",
 *         Location = "westus",
 *         PointInTimeUTC = "2017-12-14T00:00:37.467Z",
 *         ResourceGroupName = "TestGroup",
 *         SourceLocation = "westus",
 *         SourceResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/source-cluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewCluster(ctx, "cluster", &dbforpostgresql.ClusterArgs{
 * 			ClusterName:       pulumi.String("testcluster"),
 * 			Location:          pulumi.String("westus"),
 * 			PointInTimeUTC:    pulumi.String("2017-12-14T00:00:37.467Z"),
 * 			ResourceGroupName: pulumi.String("TestGroup"),
 * 			SourceLocation:    pulumi.String("westus"),
 * 			SourceResourceId:  pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/source-cluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Cluster;
 * import com.pulumi.azurenative.dbforpostgresql.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("testcluster")
 *             .location("westus")
 *             .pointInTimeUTC("2017-12-14T00:00:37.467Z")
 *             .resourceGroupName("TestGroup")
 *             .sourceLocation("westus")
 *             .sourceResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/source-cluster")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new cluster as a read replica
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.DBforPostgreSQL.Cluster("cluster", new()
 *     {
 *         ClusterName = "testcluster",
 *         Location = "westus",
 *         ResourceGroupName = "TestGroup",
 *         SourceLocation = "westus",
 *         SourceResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/sourcecluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewCluster(ctx, "cluster", &dbforpostgresql.ClusterArgs{
 * 			ClusterName:       pulumi.String("testcluster"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("TestGroup"),
 * 			SourceLocation:    pulumi.String("westus"),
 * 			SourceResourceId:  pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/sourcecluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Cluster;
 * import com.pulumi.azurenative.dbforpostgresql.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("testcluster")
 *             .location("westus")
 *             .resourceGroupName("TestGroup")
 *             .sourceLocation("westus")
 *             .sourceResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/sourcecluster")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new multi-node cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.DBforPostgreSQL.Cluster("cluster", new()
 *     {
 *         AdministratorLoginPassword = "password",
 *         CitusVersion = "11.1",
 *         ClusterName = "testcluster-multinode",
 *         CoordinatorEnablePublicIpAccess = true,
 *         CoordinatorServerEdition = "GeneralPurpose",
 *         CoordinatorStorageQuotaInMb = 524288,
 *         CoordinatorVCores = 4,
 *         EnableHa = true,
 *         EnableShardsOnCoordinator = false,
 *         Location = "westus",
 *         NodeCount = 3,
 *         NodeEnablePublicIpAccess = false,
 *         NodeServerEdition = "MemoryOptimized",
 *         NodeStorageQuotaInMb = 524288,
 *         NodeVCores = 8,
 *         PostgresqlVersion = "15",
 *         PreferredPrimaryZone = "1",
 *         ResourceGroupName = "TestGroup",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewCluster(ctx, "cluster", &dbforpostgresql.ClusterArgs{
 * 			AdministratorLoginPassword:      pulumi.String("password"),
 * 			CitusVersion:                    pulumi.String("11.1"),
 * 			ClusterName:                     pulumi.String("testcluster-multinode"),
 * 			CoordinatorEnablePublicIpAccess: pulumi.Bool(true),
 * 			CoordinatorServerEdition:        pulumi.String("GeneralPurpose"),
 * 			CoordinatorStorageQuotaInMb:     pulumi.Int(524288),
 * 			CoordinatorVCores:               pulumi.Int(4),
 * 			EnableHa:                        pulumi.Bool(true),
 * 			EnableShardsOnCoordinator:       pulumi.Bool(false),
 * 			Location:                        pulumi.String("westus"),
 * 			NodeCount:                       pulumi.Int(3),
 * 			NodeEnablePublicIpAccess:        pulumi.Bool(false),
 * 			NodeServerEdition:               pulumi.String("MemoryOptimized"),
 * 			NodeStorageQuotaInMb:            pulumi.Int(524288),
 * 			NodeVCores:                      pulumi.Int(8),
 * 			PostgresqlVersion:               pulumi.String("15"),
 * 			PreferredPrimaryZone:            pulumi.String("1"),
 * 			ResourceGroupName:               pulumi.String("TestGroup"),
 * 			Tags:                            nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Cluster;
 * import com.pulumi.azurenative.dbforpostgresql.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .administratorLoginPassword("password")
 *             .citusVersion("11.1")
 *             .clusterName("testcluster-multinode")
 *             .coordinatorEnablePublicIpAccess(true)
 *             .coordinatorServerEdition("GeneralPurpose")
 *             .coordinatorStorageQuotaInMb(524288)
 *             .coordinatorVCores(4)
 *             .enableHa(true)
 *             .enableShardsOnCoordinator(false)
 *             .location("westus")
 *             .nodeCount(3)
 *             .nodeEnablePublicIpAccess(false)
 *             .nodeServerEdition("MemoryOptimized")
 *             .nodeStorageQuotaInMb(524288)
 *             .nodeVCores(8)
 *             .postgresqlVersion("15")
 *             .preferredPrimaryZone("1")
 *             .resourceGroupName("TestGroup")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new single node Burstable 1 vCore cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.DBforPostgreSQL.Cluster("cluster", new()
 *     {
 *         AdministratorLoginPassword = "password",
 *         CitusVersion = "11.3",
 *         ClusterName = "testcluster-burstablev1",
 *         CoordinatorEnablePublicIpAccess = true,
 *         CoordinatorServerEdition = "BurstableMemoryOptimized",
 *         CoordinatorStorageQuotaInMb = 131072,
 *         CoordinatorVCores = 1,
 *         EnableHa = false,
 *         EnableShardsOnCoordinator = true,
 *         Location = "westus",
 *         NodeCount = 0,
 *         PostgresqlVersion = "15",
 *         PreferredPrimaryZone = "1",
 *         ResourceGroupName = "TestGroup",
 *         Tags =
 *         {
 *             { "owner", "JohnDoe" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewCluster(ctx, "cluster", &dbforpostgresql.ClusterArgs{
 * 			AdministratorLoginPassword:      pulumi.String("password"),
 * 			CitusVersion:                    pulumi.String("11.3"),
 * 			ClusterName:                     pulumi.String("testcluster-burstablev1"),
 * 			CoordinatorEnablePublicIpAccess: pulumi.Bool(true),
 * 			CoordinatorServerEdition:        pulumi.String("BurstableMemoryOptimized"),
 * 			CoordinatorStorageQuotaInMb:     pulumi.Int(131072),
 * 			CoordinatorVCores:               pulumi.Int(1),
 * 			EnableHa:                        pulumi.Bool(false),
 * 			EnableShardsOnCoordinator:       pulumi.Bool(true),
 * 			Location:                        pulumi.String("westus"),
 * 			NodeCount:                       pulumi.Int(0),
 * 			PostgresqlVersion:               pulumi.String("15"),
 * 			PreferredPrimaryZone:            pulumi.String("1"),
 * 			ResourceGroupName:               pulumi.String("TestGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"owner": pulumi.String("JohnDoe"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Cluster;
 * import com.pulumi.azurenative.dbforpostgresql.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .administratorLoginPassword("password")
 *             .citusVersion("11.3")
 *             .clusterName("testcluster-burstablev1")
 *             .coordinatorEnablePublicIpAccess(true)
 *             .coordinatorServerEdition("BurstableMemoryOptimized")
 *             .coordinatorStorageQuotaInMb(131072)
 *             .coordinatorVCores(1)
 *             .enableHa(false)
 *             .enableShardsOnCoordinator(true)
 *             .location("westus")
 *             .nodeCount(0)
 *             .postgresqlVersion("15")
 *             .preferredPrimaryZone("1")
 *             .resourceGroupName("TestGroup")
 *             .tags(Map.of("owner", "JohnDoe"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new single node Burstable 2 vCores cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.DBforPostgreSQL.Cluster("cluster", new()
 *     {
 *         AdministratorLoginPassword = "password",
 *         CitusVersion = "11.3",
 *         ClusterName = "testcluster-burstablev2",
 *         CoordinatorEnablePublicIpAccess = true,
 *         CoordinatorServerEdition = "BurstableGeneralPurpose",
 *         CoordinatorStorageQuotaInMb = 131072,
 *         CoordinatorVCores = 2,
 *         EnableHa = false,
 *         EnableShardsOnCoordinator = true,
 *         Location = "westus",
 *         NodeCount = 0,
 *         PostgresqlVersion = "15",
 *         PreferredPrimaryZone = "1",
 *         ResourceGroupName = "TestGroup",
 *         Tags =
 *         {
 *             { "owner", "JohnDoe" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewCluster(ctx, "cluster", &dbforpostgresql.ClusterArgs{
 * 			AdministratorLoginPassword:      pulumi.String("password"),
 * 			CitusVersion:                    pulumi.String("11.3"),
 * 			ClusterName:                     pulumi.String("testcluster-burstablev2"),
 * 			CoordinatorEnablePublicIpAccess: pulumi.Bool(true),
 * 			CoordinatorServerEdition:        pulumi.String("BurstableGeneralPurpose"),
 * 			CoordinatorStorageQuotaInMb:     pulumi.Int(131072),
 * 			CoordinatorVCores:               pulumi.Int(2),
 * 			EnableHa:                        pulumi.Bool(false),
 * 			EnableShardsOnCoordinator:       pulumi.Bool(true),
 * 			Location:                        pulumi.String("westus"),
 * 			NodeCount:                       pulumi.Int(0),
 * 			PostgresqlVersion:               pulumi.String("15"),
 * 			PreferredPrimaryZone:            pulumi.String("1"),
 * 			ResourceGroupName:               pulumi.String("TestGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"owner": pulumi.String("JohnDoe"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Cluster;
 * import com.pulumi.azurenative.dbforpostgresql.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .administratorLoginPassword("password")
 *             .citusVersion("11.3")
 *             .clusterName("testcluster-burstablev2")
 *             .coordinatorEnablePublicIpAccess(true)
 *             .coordinatorServerEdition("BurstableGeneralPurpose")
 *             .coordinatorStorageQuotaInMb(131072)
 *             .coordinatorVCores(2)
 *             .enableHa(false)
 *             .enableShardsOnCoordinator(true)
 *             .location("westus")
 *             .nodeCount(0)
 *             .postgresqlVersion("15")
 *             .preferredPrimaryZone("1")
 *             .resourceGroupName("TestGroup")
 *             .tags(Map.of("owner", "JohnDoe"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new single node cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.DBforPostgreSQL.Cluster("cluster", new()
 *     {
 *         AdministratorLoginPassword = "password",
 *         CitusVersion = "11.3",
 *         ClusterName = "testcluster-singlenode",
 *         CoordinatorEnablePublicIpAccess = true,
 *         CoordinatorServerEdition = "GeneralPurpose",
 *         CoordinatorStorageQuotaInMb = 131072,
 *         CoordinatorVCores = 8,
 *         EnableHa = true,
 *         EnableShardsOnCoordinator = true,
 *         Location = "westus",
 *         NodeCount = 0,
 *         PostgresqlVersion = "15",
 *         PreferredPrimaryZone = "1",
 *         ResourceGroupName = "TestGroup",
 *         Tags =
 *         {
 *             { "owner", "JohnDoe" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewCluster(ctx, "cluster", &dbforpostgresql.ClusterArgs{
 * 			AdministratorLoginPassword:      pulumi.String("password"),
 * 			CitusVersion:                    pulumi.String("11.3"),
 * 			ClusterName:                     pulumi.String("testcluster-singlenode"),
 * 			CoordinatorEnablePublicIpAccess: pulumi.Bool(true),
 * 			CoordinatorServerEdition:        pulumi.String("GeneralPurpose"),
 * 			CoordinatorStorageQuotaInMb:     pulumi.Int(131072),
 * 			CoordinatorVCores:               pulumi.Int(8),
 * 			EnableHa:                        pulumi.Bool(true),
 * 			EnableShardsOnCoordinator:       pulumi.Bool(true),
 * 			Location:                        pulumi.String("westus"),
 * 			NodeCount:                       pulumi.Int(0),
 * 			PostgresqlVersion:               pulumi.String("15"),
 * 			PreferredPrimaryZone:            pulumi.String("1"),
 * 			ResourceGroupName:               pulumi.String("TestGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"owner": pulumi.String("JohnDoe"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Cluster;
 * import com.pulumi.azurenative.dbforpostgresql.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .administratorLoginPassword("password")
 *             .citusVersion("11.3")
 *             .clusterName("testcluster-singlenode")
 *             .coordinatorEnablePublicIpAccess(true)
 *             .coordinatorServerEdition("GeneralPurpose")
 *             .coordinatorStorageQuotaInMb(131072)
 *             .coordinatorVCores(8)
 *             .enableHa(true)
 *             .enableShardsOnCoordinator(true)
 *             .location("westus")
 *             .nodeCount(0)
 *             .postgresqlVersion("15")
 *             .preferredPrimaryZone("1")
 *             .resourceGroupName("TestGroup")
 *             .tags(Map.of("owner", "JohnDoe"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbforpostgresql:Cluster testcluster-singlenode /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/{clusterName}
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.azurenative.dbforpostgresql.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * The administrator's login name of the servers in the cluster.
     */
    public val administratorLogin: Output<String>
        get() = javaResource.administratorLogin().applyValue({ args0 -> args0 })

    /**
     * The Citus extension version on all cluster servers.
     */
    public val citusVersion: Output<String>?
        get() = javaResource.citusVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If public access is enabled on coordinator.
     */
    public val coordinatorEnablePublicIpAccess: Output<Boolean>?
        get() = javaResource.coordinatorEnablePublicIpAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The edition of a coordinator server (default: GeneralPurpose). Required for creation.
     */
    public val coordinatorServerEdition: Output<String>?
        get() = javaResource.coordinatorServerEdition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage of a server in MB. Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
     */
    public val coordinatorStorageQuotaInMb: Output<Int>?
        get() = javaResource.coordinatorStorageQuotaInMb().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The vCores count of a server (max: 96). Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
     */
    public val coordinatorVCores: Output<Int>?
        get() = javaResource.coordinatorVCores().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The earliest restore point time (ISO8601 format) for the cluster.
     */
    public val earliestRestoreTime: Output<String>
        get() = javaResource.earliestRestoreTime().applyValue({ args0 -> args0 })

    /**
     * If high availability (HA) is enabled or not for the cluster.
     */
    public val enableHa: Output<Boolean>?
        get() = javaResource.enableHa().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If distributed tables are placed on coordinator or not. Should be set to 'true' on single node clusters. Requires shard rebalancing after value is changed.
     */
    public val enableShardsOnCoordinator: Output<Boolean>?
        get() = javaResource.enableShardsOnCoordinator().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Maintenance window of a cluster.
     */
    public val maintenanceWindow: Output<MaintenanceWindowResponse>?
        get() = javaResource.maintenanceWindow().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> maintenanceWindowResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Worker node count of the cluster. When node count is 0, it represents a single node configuration with the ability to create distributed tables on that node. 2 or more worker nodes represent multi-node configuration. Node count value cannot be 1. Required for creation.
     */
    public val nodeCount: Output<Int>?
        get() = javaResource.nodeCount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If public access is enabled on worker nodes.
     */
    public val nodeEnablePublicIpAccess: Output<Boolean>?
        get() = javaResource.nodeEnablePublicIpAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The edition of a node server (default: MemoryOptimized).
     */
    public val nodeServerEdition: Output<String>?
        get() = javaResource.nodeServerEdition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage in MB on each worker node. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
     */
    public val nodeStorageQuotaInMb: Output<Int>?
        get() = javaResource.nodeStorageQuotaInMb().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The compute in vCores on each worker node (max: 104). See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
     */
    public val nodeVCores: Output<Int>?
        get() = javaResource.nodeVCores().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date and time in UTC (ISO8601 format) for cluster restore.
     */
    public val pointInTimeUTC: Output<String>?
        get() = javaResource.pointInTimeUTC().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The major PostgreSQL version on all cluster servers.
     */
    public val postgresqlVersion: Output<String>?
        get() = javaResource.postgresqlVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Preferred primary availability zone (AZ) for all cluster servers.
     */
    public val preferredPrimaryZone: Output<String>?
        get() = javaResource.preferredPrimaryZone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The private endpoint connections for a cluster.
     */
    public val privateEndpointConnections: Output<List<SimplePrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> simplePrivateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Provisioning state of the cluster
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The array of read replica clusters.
     */
    public val readReplicas: Output<List<String>>
        get() = javaResource.readReplicas().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The list of server names in the cluster
     */
    public val serverNames: Output<List<ServerNameItemResponse>>
        get() = javaResource.serverNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serverNameItemResponseToKotlin(args0)
                })
            })
        })

    /**
     * The Azure region of source cluster for read replica clusters.
     */
    public val sourceLocation: Output<String>?
        get() = javaResource.sourceLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource id of source cluster for read replica clusters.
     */
    public val sourceResourceId: Output<String>?
        get() = javaResource.sourceResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A state of a cluster/server that is visible to user.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dbforpostgresql.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.azurenative.dbforpostgresql.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
