@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Configuration].
 */
@PulumiTagMarker
public class ConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationArgs = ConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationArgsBuilder.() -> Unit) {
        val builder = ConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Configuration {
        val builtJavaResource =
            com.pulumi.azurenative.dbforpostgresql.Configuration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Configuration(builtJavaResource)
    }
}

/**
 * Represents a Configuration.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2017-12-01.
 * Other available API versions: 2017-12-01, 2023-03-01-preview, 2023-06-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Update a user configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configuration = new AzureNative.DBforPostgreSQL.Configuration("configuration", new()
 *     {
 *         ConfigurationName = "event_scheduler",
 *         ResourceGroupName = "testrg",
 *         ServerName = "testserver",
 *         Source = "user-override",
 *         Value = "on",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewConfiguration(ctx, "configuration", &dbforpostgresql.ConfigurationArgs{
 * 			ConfigurationName: pulumi.String("event_scheduler"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerName:        pulumi.String("testserver"),
 * 			Source:            pulumi.String("user-override"),
 * 			Value:             pulumi.String("on"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Configuration;
 * import com.pulumi.azurenative.dbforpostgresql.ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configuration = new Configuration("configuration", ConfigurationArgs.builder()
 *             .configurationName("event_scheduler")
 *             .resourceGroupName("testrg")
 *             .serverName("testserver")
 *             .source("user-override")
 *             .value("on")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbforpostgresql:Configuration event_scheduler /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/configurations/{configurationName}
 * ```
 */
public class Configuration internal constructor(
    override val javaResource: com.pulumi.azurenative.dbforpostgresql.Configuration,
) : KotlinCustomResource(javaResource, ConfigurationMapper) {
    /**
     * Allowed values of the configuration.
     */
    public val allowedValues: Output<String>
        get() = javaResource.allowedValues().applyValue({ args0 -> args0 })

    /**
     * Data type of the configuration.
     */
    public val dataType: Output<String>
        get() = javaResource.dataType().applyValue({ args0 -> args0 })

    /**
     * Default value of the configuration.
     */
    public val defaultValue: Output<String>
        get() = javaResource.defaultValue().applyValue({ args0 -> args0 })

    /**
     * Description of the configuration.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Configuration documentation link.
     */
    public val documentationLink: Output<String>
        get() = javaResource.documentationLink().applyValue({ args0 -> args0 })

    /**
     * Configuration is pending restart or not.
     */
    public val isConfigPendingRestart: Output<Boolean>
        get() = javaResource.isConfigPendingRestart().applyValue({ args0 -> args0 })

    /**
     * Configuration dynamic or static.
     */
    public val isDynamicConfig: Output<Boolean>
        get() = javaResource.isDynamicConfig().applyValue({ args0 -> args0 })

    /**
     * Configuration read-only or not.
     */
    public val isReadOnly: Output<Boolean>
        get() = javaResource.isReadOnly().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Source of the configuration.
     */
    public val source: Output<String>?
        get() = javaResource.source().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Configuration unit.
     */
    public val unit: Output<String>
        get() = javaResource.unit().applyValue({ args0 -> args0 })

    /**
     * Value of the configuration.
     */
    public val `value`: Output<String>?
        get() = javaResource.`value`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ConfigurationMapper : ResourceMapper<Configuration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dbforpostgresql.Configuration::class == javaResource::class

    override fun map(javaResource: Resource): Configuration = Configuration(
        javaResource as
            com.pulumi.azurenative.dbforpostgresql.Configuration,
    )
}

/**
 * @see [Configuration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Configuration].
 */
public suspend fun configuration(
    name: String,
    block: suspend ConfigurationResourceBuilder.() -> Unit,
): Configuration {
    val builder = ConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Configuration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configuration(name: String): Configuration {
    val builder = ConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
